package com.rapid.j2ee.framework.core.io.http;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.util.EntityUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.NetworkDisconnectSystemException;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class HttpGetClient {

	private HttpClient httpClient = new DefaultHttpClient();

	private HttpGet httpGet = null;

	private String url;

	private String logInfo;

	private String charset;

	public HttpGetClient(String url) {
		this(url, "utf-8");
	}

	public HttpGetClient(String url, String charset) {

		this.url = url;

		this.charset = charset;

		String urlParameters = StringUtils.replaceAll(StringUtils
				.trimToEmpty(StringUtils.substringAfter(this.url, "?")),
				URL_Parameter_Encode_Map);

		if (!TypeChecker.isEmpty(urlParameters)) {

			try {
				urlParameters = URLEncoder.encode(urlParameters, charset);
			} catch (Exception e) {

			}

			this.url = StringUtils.substringBefore(this.url, "?")
					+ "?"
					+ StringUtils.replaceAll(urlParameters,
							URL_Parameter_Decode_Map);
		}

		httpGet = new HttpGet(this.url);

		// 连接时间15s
		httpGet.getParams().setParameter(
				CoreConnectionPNames.CONNECTION_TIMEOUT, 15000);

		// 数据传输时间60s
		httpGet.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT,
				60000 * 5);

	}

	public void setHeader(String name, String value) {
		httpGet.setHeader(name, value);
	}

	public HttpResponseEntity execute() {

		try {

			String userAgent = getUserAgent();

			httpGet.setHeader("Accept", "*/*");

			httpGet.setHeader("User-Agent", userAgent);

			int ip1 = getIPValue();
			int ip2 = getIPValue();
			int ip3 = getIPValue();
			int ip4 = getIPValue();

			httpGet.setHeader("X-Forwarded-For", "192." + ip1 + "." + ip2 + "."
					+ ip3);

			logInfo = "IP:" + "192." + ip1 + "." + ip2 + "." + ip3
					+ " userAgent:" + userAgent;

			HttpResponse response = httpClient.execute(httpGet);

			int statusCode = response.getStatusLine().getStatusCode();

			if (statusCode == 200 || statusCode == 404 || statusCode == 505) {

				return new HttpResponseEntity(response, response.getEntity(),
						statusCode);
			}

			throw new RuntimeException("Sorry, Cannot connect to " + this.url
					+ "! Returned status code :" + +statusCode);

		} catch (java.net.ConnectException connectException) {

			throw new NetworkDisconnectSystemException(
					"Sorry, Cannot connect to " + this.url, connectException);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public String executeContent() {
		return this.executeContent(charset);
	}

	public String executeContent(String charset) {
		try {
			HttpResponseEntity entity = execute();

			try {

				return EntityUtils.toString(entity, charset);

			} catch (Exception e) {
				System.out.println(logInfo);
				return "";
			}

		} finally {
			this.shutdown();
		}

	}

	public String executeContentWithoutExp(String charset) {

		try {
			HttpResponseEntity entity = execute();

			return EntityUtils.toString(entity, charset);

		} catch (Exception e) {
			System.out.println(logInfo);
			return "";
		}

		finally {
			this.shutdown();
		}

	}

	public void shutdown() {

		try {
			httpClient.getConnectionManager().shutdown();
		} catch (Exception e) {

		}
	}

	private synchronized static int getIPValue() {

		int max = 254;
		int min = 1;

		return random.nextInt(max) % (max - min + 1) + min;
	}

	private synchronized static String getUserAgent() {

		int max = User_Agents.length - 1;
		int min = 0;

		return User_Agents[(random.nextInt(max) % (max - min + 1) + min)];
	}

	private static Map<String, String> URL_Parameter_Encode_Map = new HashMap<String, String>();

	private static Map<String, String> URL_Parameter_Decode_Map = new HashMap<String, String>();

	static {

		URL_Parameter_Encode_Map.put("&", "__________");
		URL_Parameter_Encode_Map.put("=", "____ABC___");

		URL_Parameter_Decode_Map.put("__________", "&");
		URL_Parameter_Decode_Map.put("____ABC___", "=");

	}

	private static final String[] User_Agents = new String[] {
			"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/34.0.1847.116 Safari/537.36",
			"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)",
			"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2)",
			"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2)",
			"Mozilla/5.0 (iPhone; U; CPU like Mac OS X; en) AppleWebKit/420+ (KHTML, like Gecko)",
			"Opera/9.80 (Android 2.3.3; Linux; Opera Mobi/ADR-1111101157; U; ja) Presto/2.9.201 Version/11.50",
			"Mozilla/5.0 (Android; Linux armv7l; rv:9.0) Gecko/20111216 Firefox/9.0 Fennec/9.0",
			"BlackBerry9000/4.6.0.294 Profile/MIDP-2.0 Configuration/CLDC-1.1 VendorID/220",
			"Mozilla/5.0 (BlackBerry; U; BlackBerry 9900; ja) AppleWebKit/534.11+ (KHTML, like Gecko) Version/7.1.0.74 Mobile Safari/534.11+",
			"Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)",
			"Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/3.0.195.38 Safari/532.0",
			"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.107 Safari/535.1",
			"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30618; Lunascape 4.7.3),",
			"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/534.30 (KHTML, like Gecko) Chrome/12.0.742.122 Safari/534.30 ChromePlus/1.6.3.1",
			"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/13.0.782.107 Safari/535.1",
			"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.2 (KHTML, like Gecko) Chrome/15.0.874.120 Safari/535.2",
			"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.2 (KHTML, like Gecko) Chrome/15.0.874.120 Safari/535.4",
			"Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)",
			"Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; InfoPath.1",
			"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.0.04506; InfoPath.1)",
			"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; Media Center PC 5.0; .NET CLR 3.0.04506; InfoPath.1)",
			"Mozilla/4.0 (compatible; MSIE 5.0; MSN 2.5; Windows 98)",
			"Mozilla/4.0 (compatible; MSIE 5.0; Windows 95; Yahoo! JAPAN Version Windows 95/NT CD-ROM Edition 1.0.)",
			"Mozilla/4.0 (compatible; MSIE 4.01; Windows 95; Yahoo! JAPAN Version Windows 95/NT CD-ROM Edition 1.0.)",
			"Mozilla/5.0 (SymbianOS/9.2; U; Series60/3.1 NokiaN95/10.0.018; Profile/MIDP-2.0 ",
			"Opera/9.00 (Windows NT 5.1; U; ja)",
			"Opera/9.00 (Macintosh; PPC Mac OS X; U; ja)",
			"Opera/9.21 (Windows NT 6.0; U; ja)",
			"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; ja) Opera 8.02",
			"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1) Opera 7.22 [ja]",
			"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.52.7 (KHTML, like Gecko) Version/5.1.2 Safari/534.52.7",
			"Mozilla/5.0 (Macintosh; U; PPC Mac OS X; ja-jp) AppleWebKit/523.12.2 (KHTML, like Gecko) Version/3.0.4 Safari/523.12.2",
			"Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; ja-JP-mac; rv:1.8) Gecko/20051111 Firefox/1.5",
			"Mozilla/4.8 [ja] (X11; U; SunOS 5.7 sun4u)",
			"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/535.1 (KHTML, like Gecko) Chrome/14.0.835.202 Safari/535.1",
			"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)",
			"Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322; NOKTURNAL KICKS ASS)",
			"Mozilla/5.0 (SymbianOS/9.1; U; [en]; SymbianOS/91 Series60/3.0) AppleWebkit/413 (KHTML, like Gecko) Safari/413",
			"Mozilla/5.0 (SymbianOS/9.1; U; [en]; Series60/3.0 NokiaE60/4.06.0) AppleWebKit/413 (KHTML, like Gecko) Safari/413",
			"Mozilla/5.0 (SymbianOS/9.2; U; Series60/3.1 NokiaN95/10.0.018; Profile/MIDP-2.0 Configuration/CLDC-1.1) AppleWebKit/413 (KHTML, like Gecko) Safari/413",
			"Mozilla/5.0 (SymbianOS/9.3; Series60/3.2 NokiaE5-00.2/071.003; Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/533.4 (KHTML, like Gecko) NokiaBrowser/7.3.1.26 Mobile Safari/533.4 3gpp-gba",
			"Mozilla/5.0 (SymbianOS/9.3; U; Series60/3.2 NokiaE75-1/110.48.125 Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/413 (KHTML, like Gecko) Safari/413",
			"Mozilla/5.0 (SymbianOS/9.4; U; Series60/5.0 Nokia5800d-1/21.0.025; Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/413 (KHTML, like Gecko) Safari/413",
			"Mozilla/5.0 (SymbianOS/9.4; Series60/5.0 NokiaN97-1/12.0.024; Profile/MIDP-2.1 Configuration/CLDC-1.1; en-us) AppleWebKit/525 (KHTML, like Gecko) BrowserNG/7.1.12344",
			"Mozilla/5.0 (Symbian/3; Series60/5.3 Nokia701/111.020.0307; Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/533.4 (KHTML, like Gecko) NokiaBrowser/7.4.1.14 Mobile Safari/533.4 3gpp-gba",
			"Mozilla/5.0 (Linux; U; Android 3.0.1; ja-jp; MZ604 Build/H.6.2-20) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.1; en-us; K1 Build/HMJ37) AppleWebKit/534.13(KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.1; ja-jp; AT100 Build/HMJ37) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.1; ja-jp; Sony Tablet S Build/THMAS10000) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.2; ja-jp; SC-01D Build/MASTER) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.2; ja-jp; AT1S0 Build/HTJ85B) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.2; ja-jp; F-01D Build/F0001) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.2; ja-jp; Sony Tablet S Build/THMAS11000) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13",
			"Mozilla/5.0 (Linux; U; Android 3.2; ja-jp; A01SH Build/HTJ85B) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Safari/533.1",
			"Mozilla/5.0 (Linux; U; Android 3.2.1; ja-jp; Transformer TF101 Build/HTK75) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13" };

	private static final Random random = new Random(System.currentTimeMillis());

	public static void main(String[] args) {
		HttpGetClient toolkit = new HttpGetClient(
				"http://www.baidu.com?name=~ABC1!@#$^*()_+2&test=1");

		System.out.println(toolkit.executeContent());

		// /servlet/SessionRemoveActionServlet?sessionid=xxxxxxxxxxx

	}
}
