package com.rapid.j2ee.framework.core.io.http;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.NetworkDisconnectSystemException;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class HttpPostClient {

	private HttpClient httpClient;

	private HttpPost post;

	private List<NameValuePair> params;

	private String encoding;

	private String HTTPS_HEAD = "https://";

	private int HTTPS_DEFAULT_PORT = 443;

	private List<FileEntity> attacheds = ObjectUtils.EMPTY_LIST;

	private HttpClientSendPreparation httpClientSendPreparation;

	private String url;

	public HttpPostClient(String url) {
		this(url, "utf-8", 10);
	}

	public HttpPostClient(String url, String encoding) {
		this(url, encoding, 10);
	}

	public HttpPostClient(String url, String encoding, int parameterSize) {

		this.url = url;

		httpClient = new DefaultHttpClient();

		post = new HttpPost(url);

		params = new ArrayList<NameValuePair>(parameterSize);

		this.encoding = encoding;

		// timeout 15sec
		this.setConnectionTimeout(1000 * 30);

		this.enableSSLAutoProcess(url);

	}

	public void addHeader(String name, String value) {
		post.addHeader(name, value);
	}

	public void setHeader(String name, String value) {
		post.setHeader(name, value);
	}

	public void setConnectionTimeout(int timeout) {
		httpClient.getParams().setIntParameter("http.socket.timeout", timeout);
	}

	public void setHttpMethodTimeout(int timeout) {
		post.getParams().setIntParameter("http.socket.timeout", timeout);
	}

	public void addAttachedFile(String name, File file) {

		if (attacheds == ObjectUtils.EMPTY_LIST) {

			this.attacheds = new ArrayList<FileEntity>();
		}

		FileEntity entity = new FileEntity(name, file);

		this.attacheds.add(entity);

	}

	public void addHttpClientSendPreparation(
			HttpClientSendPreparation httpClientSendPreparation) {
		this.httpClientSendPreparation = httpClientSendPreparation;
	}

	public void addParameter(String key, String value) {
		params.add(new BasicNameValuePair(key, value));
	}

	public HttpResponseEntity execute() {
		try {

			post.setEntity(getHttpFormEntity());

			if (!TypeChecker.isNull(httpClientSendPreparation)) {
				httpClientSendPreparation.prepare(post);
			}

			HttpResponse response = httpClient.execute(post);

			int statusCode = response.getStatusLine().getStatusCode();

			if (statusCode == 200 || statusCode == 404 || statusCode == 505) {

				return new HttpResponseEntity(response, response.getEntity(),
						statusCode);
			}

			throw new RuntimeException("Sorry, Cannot connect to " + this.url
					+ "! Returned status code :" + +statusCode);

		} catch (java.net.ConnectException connectException) {
			throw new NetworkDisconnectSystemException(
					"Sorry, Cannot connect to " + this.url, connectException);
		} catch (Exception e) {
			
			e.printStackTrace();

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	public String executeContent() {
		try {
			HttpResponseEntity entity = execute();

			try {

				return EntityUtils.toString(entity, this.encoding);

			} catch (Exception e) {

				throw ExceptionUtils.convertThrowableToBaseException(e);
			}

		} finally {
			this.shutdown();
		}

	}

	public String executeContentWithoutExp() {

		try {
			HttpResponseEntity entity = execute();

			return EntityUtils.toString(entity, this.encoding);

		} catch (Exception e) {

			return "";
		}

		finally {
			this.shutdown();
		}

	}

	private void enableSSLAutoProcess(String url) {

		if (!isHttps(url)) {
			return;
		}

		DefaultSSLTrustManager.enableSSL(httpClient, getPort(url));
	}

	private int getPort(String url) {

		url = url.toLowerCase().substring(HTTPS_HEAD.length() + 1);

		int portIndex = url.indexOf(":");

		if (portIndex < 0) {
			return HTTPS_DEFAULT_PORT;
		}

		url = url.substring(portIndex + 1);

		return NumberUtils.parseInt(StringUtils.substringBefore(url, "/"),
				HTTPS_DEFAULT_PORT);

	}

	private boolean isHttps(String url) {
		return url.toLowerCase().startsWith(HTTPS_HEAD);
	}

	private HttpEntity getHttpFormEntity() throws Exception {

		if (this.attacheds.isEmpty()) {
			return new UrlEncodedFormEntity(params, encoding);
		}

		MultipartEntity multPartEntity = new MultipartEntity();

		if (!TypeChecker.isEmpty(params)) {

			for (NameValuePair pair : params) {
				multPartEntity.addPart(pair.getName(), new StringBody(pair
						.getValue()));
			}
		}

		for (FileEntity fe : this.attacheds) {
			multPartEntity.addPart(fe.name, new FileBody(fe.file));
		}

		return multPartEntity;

	}

	public List<NameValuePair> getNameValuePairs() {
		return this.params;
	}

	public void shutdown() {

		try {
			this.httpClient.getConnectionManager().shutdown();
		} catch (Exception e) {

		}
	}

	public static void main(String[] args) throws ParseException, IOException {

		HttpPostClient httpPostClient = new HttpPostClient(
				"http://127.0.0.1:8080/ChinaeTaxAppMgr/notice/noticePushUserPerformDeliveryAction.do");

		httpPostClient.addParameter("method", "SystemNoticeDeliver");

		httpPostClient.addParameter("noticeType", "SY");

		httpPostClient.addParameter("noticeSubType", "CD");

		httpPostClient.addParameter("courseName", "XXX课程");

		httpPostClient.addParameter("", "");

		HttpResponseEntity entity = httpPostClient.execute();

		String content = EntityUtils.toString(entity, Charset.forName("utf-8"));

		System.out.println(content);

		// try {

		// RequestAttRecord.aspx?verb=excelExport&query=( empno = '35673' or
		// empname like '35673%') and
		// convert(varchar(10),brushdatetime,120)>='2013-09-06' and
		// convert(varchar(10),brushdatetime,120)<='2013-09-11'
		//
		// HttpClientToolkit toolkit = new HttpClientToolkit(
		// "http://blog.csdn.net/kavensu/article/details/7611246",
		// "utf-8", 10);
		//
		// toolkit
		// .addHttpClientSendPreparation(new HttpClientSendPreparation() {
		//
		// public void prepare(HttpPost post) {
		//
		// post
		// .addHeader(
		// "Cookie",
		// "ASP.NET_SessionId=zyr0bi55qokc1ezrpu2u3n45;
		// .bshrExt=08B805E1898B3A368AD441705E4600E7B713E39D1BCCC4D092E2B5F2E8CA1D6652E0A509991A94DCCD14816154497AF7F5574F2FD33EC1E374073EC9E42B0A00589AF30740F6321761D4854A09D3D19F");
		//
		// }
		//
		// });
		//
		// HttpResponseEntity entity = toolkit.execute();
		//
		// String content = EntityUtils.toString(entity, Charset
		// .forName("utf-8"));
		//
		// System.out.println(content);
		//
		// toolkit.shutdown();

		// HttpClientToolkit toolkit = new HttpClientToolkit(
		// "http://10.10.168.20:8080/OA/BangTodoOA/OATaskResourceSubmitFlow.html",
		// "utf-8", 3);
		//
		// toolkit.addParameter("infoId", "CX130723093423358");
		// toolkit.addParameter("notion", "ok");
		// toolkit.addParameter("employeeNoL", "gdkHizAmx0ysUdeRHOKLJA==");
		//
		// HttpResponseEntity entity = toolkit.execute();
		//
		// String xml = EntityUtils.toString(entity,
		// Charset.forName("gbk"));
		//
		// System.out.println("First （infoId）====== " + xml);
		//
		// XPathParser xmlParser = new XPathParser(xml);
		//
		// HttpClientToolkit submitFlow = new HttpClientToolkit(
		// "http://10.10.168.20:8080/OA/BangTodoOA/OATaskResourceSubmitFlow.html",
		// "utf-8", 20);
		// List<XNode> nodes = xmlParser.evalNodes("Flow/choose/option");
		// XNode chooseOption = nodes.get(0);
		//
		// System.out.println(chooseOption.evalNode("parameter"));
		//
		// submitFlow.addParameter(chooseOption.evalNode("parameter")
		// .getStringAttribute("name"), chooseOption.evalNode(
		// "parameter").getStringAttribute("value"));
		//
		// submitFlow.addParameter("employeeNoL",
		// "gdkHizAmx0ysUdeRHOKLJA==");
		//
		// for (XNode param :
		// xmlParser.evalNode("Flow/params").getChildren()) {
		// System.out.println(param.getName() + "="
		// + StringUtils.trimToEmpty(param.getStringBody()));
		//
		// submitFlow.addParameter(param.getName(), StringUtils
		// .trimToEmpty(param.getStringBody()));
		// }
		//
		// System.out.println(submitFlow.getNameValuePairs());
		//
		// entity = submitFlow.execute();
		//
		// xml = EntityUtils.toString(entity, Charset.forName("gbk"));
		//
		// System.out.println("xml == " + xml);
		//
		// xmlParser = new XPathParser(xml);
		//
		// submitFlow = new HttpClientToolkit(
		// "http://10.10.168.20:8080/OA/BangTodoOA/OATaskResourceSubmitFlow.html",
		// "utf-8", 20);
		//
		// submitFlow.addParameter("employeeNoL",
		// "gdkHizAmx0ysUdeRHOKLJA==");
		//
		// XNode optionNode =
		// xmlParser.evalNodes("Flow/choose/option").get(0);
		//
		// for (XNode param : optionNode.evalNodes("parameter")) {
		// submitFlow.addParameter(param.getStringAttribute("name"), param
		// .getStringAttribute("value"));
		// }
		//
		// for (XNode param :
		// xmlParser.evalNode("Flow/params").getChildren()) {
		// System.out.println(param.getName() + "="
		// + StringUtils.trimToEmpty(param.getStringBody()));
		//
		// submitFlow.addParameter(param.getName(), StringUtils
		// .trimToEmpty(param.getStringBody()));
		// }
		//
		//			
		// System.out.println(submitFlow.getNameValuePairs());
		//			
		// entity = submitFlow.execute();
		//
		// xml = EntityUtils.toString(entity, Charset.forName("gbk"));
		//
		// System.out.println("xml == " + xml);

		//
		// JSONObject jsonObj = JSONObject.fromObject(json);
		//
		// JSONArray arrays = jsonObj.getJSONArray("data");
		//
		// for (int i = 0; i < arrays.size(); i++) {
		// jsonObj = arrays.getJSONObject(i);
		//
		// System.out.println(jsonObj.getString("sid"));
		//
		// }

		// } catch (ParseException e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// } catch (Exception e) {
		// // TODO Auto-generated catch block
		// e.printStackTrace();
		// }

		// WebServiceTest test = new
		// WebServiceTest();
		// test.addParameter("method",
		// );
		// test.addParameter("employeeNoS", "90008452");
		// test.execute();

	}

	private class FileEntity {
		
		public String name;

		public File file;

		public FileEntity(String name, File file) {
			this.name = name;
			this.file = file;
		}
	}

	public static interface HttpClientSendPreparation {
		public void prepare(HttpPost post);
	}

}
