package com.rapid.j2ee.framework.core.io.http;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.utils.FileCopyUtils;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;

public class HttpProxyGetClient implements HttpProxyConstants {

	private HttpClient httpClient = new DefaultHttpClient();

	private HttpPostClient httpProxyPost = null;

	private String url;

	private String proxyUrl;

	public HttpProxyGetClient(String proxyUrl, String url) {

		this.url = url;

		this.proxyUrl = proxyUrl;

		httpProxyPost = new HttpPostClient(this.proxyUrl);

	}

	public HttpResponseEntity execute() {

		String uuid = UUIDGenerator.nextUUID();

		httpProxyPost.addParameter(Orginal_URL, url);
		httpProxyPost.addParameter(Orginal_Method, "Get");
		httpProxyPost.addParameter(Security_UUID, uuid);
		httpProxyPost.addParameter(Security_SN,
				com.rapid.j2ee.framework.core.cryptology.CryptologyFactory
						.getSingleCryptology(CryptologyType.Md5).encrypt(
								uuid + url + Security_Encrypt_Salt));

		return httpProxyPost.execute();

	}

	public String executeContent() {
		return this.executeContent("utf-8");
	}

	public String executeContent(String charset) {
		try {
			HttpResponseEntity entity = execute();

			try {

				return EntityUtils.toString(entity, charset);

			} catch (Exception e) {

				e.printStackTrace();

				return "";
			}

		} finally {
			this.shutdown();
		}

	}

	public void shutdown() {

		try {
			httpClient.getConnectionManager().shutdown();
		} catch (Exception e) {

		}
	}

	public static void main(String[] args) {

		HttpProxyGetClient toolkit = new HttpProxyGetClient("http://10.10.174.48:8080/GalaxyProxy/Proxy",
				"http://www.anbang-life.com/global/inc/downloadFile.jsp?fileName=1390379646502_1390379750807.pdf");

		try {
			FileCopyUtils.copy(toolkit.execute().getContent(), new FileOutputStream("c:/1390379646502_1390379750807.pdf"));
		} catch (IllegalStateException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}


	}

}
