package com.rapid.j2ee.framework.core.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class HttpResponseEntity implements HttpEntity {

	private HttpEntity entity;

	private int statusCode;

	private HttpResponse response;

	public int getStatusCode() {
		return statusCode;
	}

	public HttpResponseEntity(HttpResponse response, HttpEntity entity,
			int statusCode) {
		this.entity = entity;
		this.statusCode = statusCode;
		this.response = response;
	}

	public void consumeContent() throws IOException {

		entity.consumeContent();
	}

	public InputStream getContent() throws IOException, IllegalStateException {

		return entity.getContent();
	}

	public Header getContentEncoding() {

		return entity.getContentEncoding();
	}

	public long getContentLength() {

		return entity.getContentLength();
	}

	public Header getContentType() {

		return entity.getContentType();
	}

	public boolean isChunked() {

		return entity.isChunked();
	}

	public boolean isRepeatable() {

		return entity.isRepeatable();
	}

	public boolean isStreaming() {

		return entity.isStreaming();
	}

	public void writeTo(OutputStream os) throws IOException {
		entity.writeTo(os);

	}

	public HttpResponse getHttpResponse() {
		return this.response;
	}

	public String getHeaderValue(String name) {

		for (Header header : getHttpResponse().getAllHeaders()) {
			if (name.equalsIgnoreCase(header.getName())) {
				return header.getValue();
			}

		}

		return "";
	}

	public String getFileName() {

		String fileName = getHeaderValue("Content-disposition") + ";";

		fileName = StringUtils.substringAfterLast(fileName, "filename=");

		fileName = StringUtils.substringBefore(fileName, ";");

		return StringUtils.remove(fileName, "\"");
	}

}
