package com.rapid.j2ee.framework.core.io.http;

import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.StreamIoUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class HttpStreamClient<T> {

	protected HttpPostClient httpPostClient;

	public HttpStreamClient() {

	}

	public HttpStreamClient(String url) {

		httpPostClient = new HttpPostClient(url);

	}

	public void setHttpStreamClientUrl(String url) {
		httpPostClient = new HttpPostClient(url);
	}

	public void addParameter(String key, String value) {
		httpPostClient.addParameter(key, value);
	}

	public void addParameterByHttpServletRequest(HttpServletRequest request,
			String... excludedParameterNames) {

		for (Object name : request.getParameterMap().keySet()) {

			if (this.isParameterNameExcluded((String) name,
					excludedParameterNames)) {
				continue;
			}

			log.info("addParametersByRequest value:"
					+ request.getParameter((String) name) + " name:" + name);

			addParameter((String) name, request.getParameter((String) name));
		}

	}

	public T readObject() {

		HttpResponseEntity httpResponseEntity = httpPostClient.execute();

		try {
			return (T) StreamIoUtils.readObject(resolve(httpResponseEntity
					.getContent()));
		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	protected InputStream resolve(InputStream is) {
		return is;
	}

	private boolean isParameterNameExcluded(String name,
			String[] excludedParameterNames) {
		if (TypeChecker.isEmpty(excludedParameterNames)) {
			return false;
		}

		for (String excludedName : excludedParameterNames) {
			if (StringUtils.equalsIgnoreCase(name, excludedName)) {
				return true;
			}
		}

		return false;
	}

	private Log log = LogFactory.getLog(HttpStreamClient.class);
}
