package com.rapid.j2ee.framework.core.io.http;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.xml.soap.SOAPException;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.http.HttpGetClient;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class HttpWebServiceClient {

	// WSDL URL
	private String url;

	// WSDL METHOD
	private String method;

	private Map<String, String> requestParameters = new HashMap<String, String>();

	private Map<String, String> requestHeaderParameters = new HashMap<String, String>();

	private String soapHeaderName;

	private SOAPHeaderElement soapHeader;

	public HttpWebServiceClient(String url, String method) {

		this.url = url;

		this.method = method;

	}

	public XPathParser execute(String requestXml) throws Exception {

		return this.executeWebService(requestXml);
	}

	private XPathParser executeWebService(String requestXml) throws Exception {

		Service service = new Service();

		Call call = (Call) service.createCall();

		this.addSOAPHeaderElements(call);

		call.setTargetEndpointAddress(new URL(url));

		call.setOperationName(method);

		String result = (String) call
				.invoke(new Object[] { resolve(requestXml) });

		Assert.hasLength(result, "没有查询到数据  URL:" + this.url + " Method:"
				+ this.method);

		return new XPathParser(result);
	}

	public void addHeaderParameters(String key, String value) {
		requestHeaderParameters.put(key, value);
	}

	public void initSoapHeader() {

		if (TypeChecker.isEmpty(requestHeaderParameters)) {
			return;
		}

		Assert.hasText(this.soapHeaderName, "没有设置soapHeaherName！");

		this.soapHeader = new SOAPHeaderElement("", this.soapHeaderName);

		try {

			for (Map.Entry<String, String> entry : requestHeaderParameters
					.entrySet()) {

				MessageElement messageElement = new MessageElement("", entry
						.getKey());

				messageElement.setObjectValue(entry.getValue());

				soapHeader.addChildElement(messageElement);
			}
		} catch (Exception e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private void addSOAPHeaderElements(Call call) throws Exception {

		if (TypeChecker.isEmptyObject(soapHeader)) {
			return;
		}

		call.addHeader(soapHeader);
	}

	public void addParameter(String name, String value) {
		requestParameters.put(name, StringUtils.trimToEmpty(value));
	}

	protected String resolve(String xml) {

		return StringUtils.replaceAll(xml, this.requestParameters, "${", "}");
	}

	public void setSoapHeaderName(String soapHeaderName) {
		this.soapHeaderName = soapHeaderName;
	}

}
