package com.rapid.j2ee.framework.core.io.http;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.NetworkDisconnectSystemException;

public class HttpXmlRequestClient extends HttpContentBodyRequestClient {

	public HttpXmlRequestClient(String requestUrl, String charset) {
		super(requestUrl, charset);

	}

	public HttpResponseEntity sendXmlAsRequest(String xml) {
		return this.execute(xml);
	}

	@Override
	protected String getContentType(String charset) {

		return "text/xml;charset=" + charset;
	}

}
