package com.rapid.j2ee.framework.core.io.image;

import java.util.regex.Matcher;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class HtmlImageAttribute {

	private String srcTagName;

	private String srcStartFlag;

	private String srcEndTag;

	private String url;

	private String srcTagType;

	public HtmlImageAttribute(Matcher matcher) {
		this.srcTagName = matcher.group(1);
		this.srcStartFlag = matcher.group(2);
		this.url = StringUtils.trimToEmpty(matcher.group(3));
		this.srcEndTag = matcher.group(5);
	}

	public String getSrcEndTag() {
		return srcEndTag;
	}

	public String getSrcStartFlag() {
		return srcStartFlag;
	}

	public String getSrcTagName() {
		return srcTagName;
	}

	public String getUrl() {
		return url;
	}

	public String getImageSrcFullUrl() {
		return this.srcStartFlag + this.url + this.srcEndTag;
	}

	
	public String getImageSrcFullUrl(String replaceUrl) {
		return this.srcStartFlag + replaceUrl + this.srcEndTag;
	}


	public String getSrcTagType() {
		return srcTagType;
	}

	public void setSrcTagType(String srcTagType) {
		this.srcTagType = srcTagType;
	}

}
