package com.rapid.j2ee.framework.core.io.image;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlImageHtmlParser {

	public HtmlImageHtmlParser() {

	}

	public String resolveImageBase64Html(String htmlContentWithImageTags) {

		Document document = Jsoup.parse(htmlContentWithImageTags);

		Elements imageElements = document.getElementsByTag("IMG");

		String newImgeSrcHtml = htmlContentWithImageTags;

		for (Element imageElement : imageElements) {

			this.reviseImageSrc(imageElement, this.htmlImageResourceResolver
					.resolve(imageElement, imageElement.attr("src")));

		}

		return document.html();
	}

	private void reviseImageSrc(Element imageElement, String imageRevisedUrl) {
		imageElement.attr("src", imageRevisedUrl);

	}

	public void setHtmlImageResourceResolver(
			HtmlImageResourceResolver htmlImageResourceResolver) {
		this.htmlImageResourceResolver = htmlImageResourceResolver;
	}

	private HtmlImageResourceResolver htmlImageResourceResolver;

}
