package com.rapid.j2ee.framework.core.io.image;

import java.io.InputStream;

import org.jsoup.nodes.Element;

import com.rapid.j2ee.framework.core.utils.ImageToBase64;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class HtmlImageResourceBase64DataHtmlResolver implements
		HtmlImageResourceResolver {

	public String resolve(Element imageElement, String imageSrc) {

		String base64Image = ImageToBase64.base64(this.getImageResource(
				imageElement, imageSrc));

		if (TypeChecker.isNull(base64Image)) {
			return imageSrc;
		}

		String imgType = StringUtils.trimToEmpty(StringUtils
				.substringAfterLast(imageSrc, "."), getImageTypeAsDefault());

		return "data:image/" + imgType + ";base64," + base64Image;

	}

	public abstract InputStream getImageResource(Element imageElement,
			String imageSrc);

	protected String getImageTypeAsDefault() {
		return "jpg";
	}
}
