package com.rapid.j2ee.framework.core.io.image;

import org.jsoup.nodes.Element;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class HtmlImageResourceSimpleReplacer implements
		HtmlImageResourceResolver {

	public String resolve(Element imageElement, String imageSrc) {

		if (imageSrc.toLowerCase().startsWith("http")
				|| imageSrc.toLowerCase().startsWith("ftp")) {
			return imageSrc;
		}

		return StringUtils.replace(replacerPattern, "{src}", imageSrc);
	}

	public void setReplacerPattern(String replacerPattern) {
		this.replacerPattern = replacerPattern;
	}

	private String replacerPattern;

}
