package com.rapid.j2ee.framework.core.io.json;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.xml.XMLSerializer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.reflect.MetaClass;
import com.rapid.j2ee.framework.core.reflect.invoker.Invoker;
import com.rapid.j2ee.framework.core.reflect.invoker.MethodInvoker;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.web.context.GeneralMvcMethodContext;

public final class JsonUtils {

	public static <T> T jsonToBean(Class<T> clz, String json) {

		return (T) JSONObject.toBean(JSONObject.fromObject(json), clz);
	}

	public static <T> T jsonToBean(Class<T> clz, JSONObject jsonObject) {

		return (T) JSONObject.toBean(jsonObject, clz);
	}

	public static <T> List<T> jsonArrayToBeans(Class<T> clz, JSONArray array) {

		if (TypeChecker.isNull(array)) {
			return ObjectUtils.EMPTY_LIST;
		}

		List<T> objects = new ArrayList<T>(array.size());

		for (int i = 0, j = array.size(); i < j; i++) {
			objects.add(jsonToBean(clz, array.getJSONObject(i)));
		}

		return objects;
	}

	public static String formatJsonText(Object obj) {

		Object json = javaObjToJsonObj(obj);

		String context = json.toString();

		if (obj instanceof JsonResolvable) {
			return ((JsonResolvable) obj).resolve(context);
		}

		return context;

	}

	public static String formatXml(Object obj, String encoding) {

		return new XMLSerializer().write(JSONObject
				.fromObject(formatJsonText(obj)), encoding);

	}

	public static String resolveJsonByRemoveContents(String jsonContext,
			String[] removeContents) {
		if (TypeChecker.isEmpty(removeContents)) {
			return jsonContext;
		}

		for (String removeContext : removeContents) {
			jsonContext = StringUtils.replace(jsonContext, removeContext, "");
		}

		jsonContext = StringUtils.replace(jsonContext, "\",,", "\",");
		jsonContext = StringUtils.replace(jsonContext, ",}", "}");
		jsonContext = StringUtils.replace(jsonContext, "{,", "{");
		jsonContext = StringUtils.replace(jsonContext, ",,\"", ",\"");

		return jsonContext;
	}

	private static Object javaObjToJsonObj(Object obj) {

		if (TypeChecker.isNull(obj)) {
			return Empty_Json;
		}

		if (obj instanceof Collection || obj instanceof Map
				|| obj instanceof Set || obj instanceof Array) {

			return new JSONArray().fromObject(obj);
		}

		JSONObject json = new JSONObject();

		MetaClass meta = MetaClass.forClass(obj.getClass());

		String[] getters = meta.getGetterNames();

		if (TypeChecker.isEmpty(getters)) {
			return Empty_Json;
		}

		for (int i = getters.length - 1; i >= 0; i--) {

			String getter = getters[i];

			Invoker invoker = (Invoker) meta.getGetInvoker(getter);

			if (invoker instanceof MethodInvoker) {

				MethodInvoker methodInvoker = (MethodInvoker) invoker;

				if (isMethodInvokerExcluded(methodInvoker)) {
					continue;
				}

				try {
					json.put(methodInvoker.invokerName(), methodInvoker.invoke(
							obj, null));
				} catch (Throwable e) {
					LOG.error("javaObjToJsonObj() error !!! Field Name = "
							+ getter, e);
				}

			}

		}

		return json;

	}

	private static boolean isMethodInvokerExcluded(MethodInvoker methodInvoker) {

		if (methodInvoker.target(JsonResolvable.class)) {
			return true;
		}

		if (!TypeChecker.isNull(methodInvoker.getField())
				&& methodInvoker.getField().isAnnotationPresent(
						JsonIgnoreField.class)) {
			return true;
		}
		if (!TypeChecker.isNull(methodInvoker.getMethod())
				&& methodInvoker.getMethod().isAnnotationPresent(
						JsonIgnoreMethod.class)) {
			return true;
		}

		return false;
	}

	private JsonUtils() {

	}

	private static final Log LOG = LogFactory.getLog(JsonUtils.class);

	public static JSONObject Empty_Json = new JSONObject();

	public static void main(String[] args) {

		GeneralMvcMethodContext result = new GeneralMvcMethodContext();
		result.setI18nMessage("hao");

		System.out.println(JsonUtils.javaObjToJsonObj(result));

		System.out.println(ObjectAnalyzer.toString(JsonUtils
				.jsonToBean(GeneralMvcMethodContext.class, JsonUtils
						.formatJsonText(result))));
	}

}
