package com.rapid.j2ee.framework.core.io.net;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

import com.rapid.j2ee.framework.core.io.ResponseOutputStream;
import com.rapid.j2ee.framework.core.io.net.disk.ResourceDiskStorageClient;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.PropertiesUtils;
import com.rapid.j2ee.framework.core.utils.ResponseUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class ResourceHttpGetClient implements InitializingBean {

	public ResourceHttpGetClient() {

	}

	public boolean get(String category, String storageFileName,
			String downloadFileName, HttpServletRequest request,
			HttpServletResponse response) {
		return this.get(category, null, storageFileName, downloadFileName,
				request, response);
	}

	public boolean get(String category, String supplyFolder,
			String storageFileName, String downloadFileName,
			HttpServletRequest request, HttpServletResponse response) {

		try {

			if (TypeChecker.isNull(downloadFileName)) {
				downloadFileName = resourceStorageClient
						.getResourceAsNotFound(category);
			}

			logger.info("Download FileName:" + downloadFileName);

			// 清空response
			response.reset();

			// 设置response的Header
			response.setContentType(getContentType(downloadFileName));

			this.confiure(request, response, downloadFileName);

			boolean result = resourceStorageClient.get(category, supplyFolder,
					storageFileName,
					new ResponseOutputStream(request, response));

			if (result == false) {

				logger.info("File Not Found!! Category:" + category
						+ " SupplyFolder:" + supplyFolder
						+ " Storage FileName:" + storageFileName);

				response.setStatus(404);
				response.setHeader("status", "404");
				response.setHeader("result-code", "404");
				response.setHeader("Content-disposition", "");

				return false;
			}

			return true;

		} catch (Exception e) {

			e.printStackTrace();

			logger.error("File Download Error!! Category:" + category
					+ " SupplyFolder:" + supplyFolder + " Storage FileName:"
					+ storageFileName, e);

			response.setHeader("status", "404");
			response.setHeader("result-code", "404");
			response.setHeader("Content-disposition", "");

			response.setStatus(404);

			e.printStackTrace();
		}

		return false;
	}

	protected void confiure(HttpServletRequest request,
			HttpServletResponse response, String downloadFileName) {

		boolean onlineReivewMode = this
				.isOnlineReviewByDefaultSettings(downloadFileName);

		if (request.getParameter(resourceOnlineReviewModeAsRequestName) != null) {
			onlineReivewMode = TypeChecker.isSpecialTrue(request
					.getParameter(resourceOnlineReviewModeAsRequestName));
		}

		if (onlineReivewMode) {

			response.setHeader("Content-disposition", "inline;filename="
					+ ResponseUtils.getResolvedFileName(request,
							downloadFileName, charsetType));

			return;
		}

		response.setHeader("Content-disposition", "attachment;filename="
				+ ResponseUtils.getResolvedFileName(request, downloadFileName,
						this.charsetType));
	}

	protected final boolean isOnlineReviewByDefaultSettings(
			String downloadFileName) {
		return StringUtils.containsIgnoreCase(mineTypeProperties
				.getProperty(Resource_Http_Download_Online_Review_FileTypes),
				FileUtils.getFileNameAndExtension(downloadFileName)[1], ",");
	}

	protected final String getContentType(String downloadFileName) {

		return mineTypeProperties.getProperty(FileUtils
				.getFileNameAndExtension(downloadFileName)[1]);
	}

	public void afterPropertiesSet() throws Exception {
		mineTypeProperties = PropertiesUtils.getProperties(
				this.mineTypePropertiesUrl, true);
	}

	public void setMineTypePropertiesUrl(String mineTypePropertiesUrl) {
		this.mineTypePropertiesUrl = mineTypePropertiesUrl;
	}

	public void setResourceStorageClient(
			ResourceStorageClient resourceStorageClient) {
		this.resourceStorageClient = resourceStorageClient;
	}

	public void setCharsetType(String charsetType) {
		this.charsetType = charsetType;
	}

	public void setResourceOnlineReviewModeAsRequestName(
			String resourceOnlineReviewModeAsRequestName) {
		this.resourceOnlineReviewModeAsRequestName = resourceOnlineReviewModeAsRequestName;
	}

	protected String charsetType = "utf-8";

	private ResourceStorageClient resourceStorageClient;

	private String mineTypePropertiesUrl = "mimetype.properties";

	private Properties mineTypeProperties;

	private String resourceOnlineReviewModeAsRequestName = "_onlineMode";

	public static final String Resource_Http_Download_Online_Review_FileTypes = "resource.online.openmode";

	private static final Log logger = LogFactory
			.getLog(ResourceHttpGetClient.class);

}
