package com.rapid.j2ee.framework.core.io.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletResponse;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;
import com.rapid.j2ee.framework.core.io.ResponseOutputStream;
import com.rapid.j2ee.framework.core.io.net.disk.category.ResourceCategoryDirectoryRegistry;
import com.rapid.j2ee.framework.core.io.net.disk.interceptor.ResourceDiskStoreageGetInterceptor;
import com.rapid.j2ee.framework.core.io.net.disk.interceptor.ResourceDiskStoreagePutInterceptor;
import com.rapid.j2ee.framework.core.utils.FileCopyUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public interface ResourceStorageClient {

	public String getResourceAsNotFound(String category);

	public boolean get(String category, String supplyFolder, String fileName,
			OutputStream os);

	public boolean get(String category, String fileName, OutputStream os);

	public boolean put(String category, String targetFileName, File sourceFile);

	public boolean put(String category, String supplyFolder,
			String targetFileName, InputStream inputStream);

	public boolean put(String category, String targetFileName,
			InputStream inputStream);

	public boolean put(String category, String supplyFolder,
			String targetFileName, File sourceFile);

	public boolean delete(String category, String supplyFolder, String fileName);

	public boolean delete(String category, String fileName);

	public String getDirectory(String category);

	public String getDirectory(String category, String supplyFolder);

	public String getMakeDirectory(String category, String supplyFolder);

	public void setResourceCategoryDirectoryRegistry(
			ResourceCategoryDirectoryRegistry resourceCategoryDirectoryRegistry);

}
