package com.rapid.j2ee.framework.core.io.net.disk.interceptor;

import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;

import com.rapid.j2ee.framework.core.utils.FileUtils;

public interface ResourceDiskStoreageGetInterceptor {

	public boolean before(String category, String supplyFolder,
			String fileName, File file, OutputStream os);

	public RandomAccessFile getRandomAccessFile(String category, File file)
			throws Exception;

	public long getSize(String category, File file);

	public static final ResourceDiskStoreageGetInterceptor Get_Default_Interceptor = new ResourceDiskStoreageGetInterceptor() {

		public boolean before(String category, String supplyFolder,
				String fileName, File file, OutputStream os) {

			return file.exists();
		}

		public RandomAccessFile getRandomAccessFile(String category, File file)
				throws Exception {

			return new RandomAccessFile(file, "r");

		}

		public long getSize(String category, File file) {

			return FileUtils.getFileSize(file);
		}

	};


}
