package com.rapid.j2ee.framework.core.io.net.ftp;

import java.beans.BeanInfo;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.bind.annotation.InitBinder;

import com.rapid.j2ee.framework.core.io.net.ResourceStorageClient;
import com.rapid.j2ee.framework.core.io.net.disk.category.ResourceCategoryDirectoryRegistry;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class ResourceFTPStorageClient extends FTPClientTemplateConfigure
		implements ResourceStorageClient, InitializingBean {

	public boolean delete(String category, String supplyFolder, String fileName) {

		return ftpClientTemplate.delete(FileUtils.getFullFilePathName(this
				.getDirectory(category, supplyFolder), fileName));

	}

	public boolean delete(String category, String fileName) {

		return ftpClientTemplate.delete(FileUtils.getFullFilePathName(this
				.getDirectory(category), fileName));
	}

	public boolean get(String category, String supplyFolder, String fileName,
			OutputStream os) {

		return ftpClientTemplate.get(FileUtils.getFullFilePathName(this
				.getDirectory(category, supplyFolder), fileName), os);
	}

	public boolean get(String category, String fileName, OutputStream os) {

		return ftpClientTemplate.get(FileUtils.getFullFilePathName(this
				.getDirectory(category), fileName), os);
	}

	public String getDirectory(String category) {

		return resourceCategoryDirectoryRegistry.getDirectory(category);
	}

	public String getDirectory(String category, String supplyFolder) {

		if (TypeChecker.isEmpty(supplyFolder)) {
			return getDirectory(category);
		}

		return FileUtils.getFullFilePathName(getDirectory(category),
				supplyFolder);
	}

	public String getMakeDirectory(String category, String supplyFolder) {

		String folder = getDirectory(category, supplyFolder);

		ftpClientTemplate.mkdirs(folder);

		return folder;
	}

	public String getResourceAsNotFound(String category) {

		return "";
	}

	public boolean put(String category, String targetFileName, File sourceFile) {

		return put(category, null, targetFileName, sourceFile);
	}

	public boolean put(String category, String supplyFolder,
			String targetFileName, File sourceFile) {

		String tempFileName = FileUtils.getFullFilePathName(supplyFolder,
				targetFileName);

		supplyFolder = StringUtils.substringBeforeLast(tempFileName, "/");

		for (int i = 0; i < uploadTryAgainMaxCountAtFailure; i++) {

			if (ftpClientTemplate.put(FileUtils.getFullFilePathName(
					getMakeDirectory(category, supplyFolder), new File(
							targetFileName).getName()), sourceFile
					.getAbsolutePath())) {
				return true;
			}
		}

		return false;

	}

	public boolean put(String category, String supplyFolder,
			String targetFileName, InputStream inputStream) {

		throw new UnsupportedOperationException(
				" put(String category, String supplyFolder, String targetFileName, InputStream inputStream)");

	}

	public boolean put(String category, String targetFileName,
			InputStream inputStream) {
		return this.put(category, null, targetFileName, inputStream);
	}

	public void setResourceCategoryDirectoryRegistry(
			ResourceCategoryDirectoryRegistry resourceCategoryDirectoryRegistry) {
		this.resourceCategoryDirectoryRegistry = resourceCategoryDirectoryRegistry;
	}

	public void afterPropertiesSet() throws Exception {

		ftpClientTemplate = new FTPClientTemplate(this);
	}

	public void setUploadTryAgainMaxCountAtFailure(
			int uploadTryAgainMaxCountAtFailure) {
		this.uploadTryAgainMaxCountAtFailure = uploadTryAgainMaxCountAtFailure;
	}

	private int uploadTryAgainMaxCountAtFailure = 3;

	private FTPClientTemplate ftpClientTemplate;

	private ResourceCategoryDirectoryRegistry resourceCategoryDirectoryRegistry;

}
