package com.rapid.j2ee.framework.core.io.qrc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * 二维码生成器
 * 
 * @author John Hao
 * 
 */
public interface ImageQRCodeClient {

	/**
	 * 生成二维码
	 * 
	 * @param content
	 * @param os
	 */
	public void encode(String content, OutputStream os);

	/**
	 * 生成二维码
	 * 
	 */
	public String encode(String category, String subCategory, String content);

	/**
	 * 生成二维码
	 * 
	 * @param content
	 * @param os
	 */
	public String encode(String category, String content);

	/**
	 * 解析二维码
	 * 
	 * @param category
	 * @param subCategory
	 * @param targetFileName
	 * @return
	 */
	public String decode(String category, String subCategory,
			String targetFileName);

	/**
	 * 解析二维码
	 * 
	 * @param category
	 * @param targetFileName
	 * @return
	 */
	public String decode(String category, String targetFileName);

	/**
	 * 解析二维码
	 * 
	 * @param is
	 * @return
	 */
	public String decode(InputStream is);
}
