package com.rapid.j2ee.framework.core.io.qrc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import com.rapid.j2ee.framework.core.charset.Charset;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.barcode.ImageQRCodeUtil;
import com.rapid.j2ee.framework.core.io.net.ResourceStorageClient;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.UUIDGenerator;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;

public class ImageQRCodeGenericClient implements ImageQRCodeClient {

	public String decode(String category, String subCategory,
			String targetFileName) {

		ByteOutputStream os = new ByteOutputStream(1024);

		resourceStorageClient.get(category, subCategory, targetFileName, os);

		FileUtils.flush(os);

		byte[] bytes = os.getBytes();

		return ImageQRCodeUtil.decode(new ByteInputStream(bytes, bytes.length),
				this.charset);
	}

	public String decode(String category, String targetFileName) {

		return decode(category, "", targetFileName);
	}

	public String decode(InputStream is) {

		return ImageQRCodeUtil.decode(is, this.charset);

	}

	public void encode(String content, OutputStream os) {

		ImageQRCodeUtil.encode(content, width, height, os);
	}

	public String encode(String category, String content) {

		return this.encode(category, "", content);

	}

	public String encode(String category, String subCategory, String content) {

		content = StringUtils.trimToEmpty(content);

		File file = new File(resourceStorageClient.getDirectory(category,
				subCategory), UUIDGenerator.nextUUID() + ".data");

		FileUtils.makeDir(file);

		OutputStream os = null;

		try {
			os = new FileOutputStream(file);

			this.encode(content, os);

		} catch (FileNotFoundException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {

			FileUtils.close(os);
		}

		resourceStorageClient.put(category, file.getName(), file);

		return TypeChecker.isEmpty(subCategory) ? file.getName() : FileUtils
				.getFullFilePathName(subCategory, file.getName());

	}

	public void setResourceStorageClient(
			ResourceStorageClient resourceStorageClient) {
		this.resourceStorageClient = resourceStorageClient;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public void setCharset(String charset) {
		this.charset = Charsets.getCharsetInstance(charset);
	}

	private Charset charset = Charsets.UTF_8;

	private int width = 120;

	private int height = 120;

	private ResourceStorageClient resourceStorageClient;

}
