package com.rapid.j2ee.framework.core.io.xls;

import java.io.OutputStream;
import java.util.Locale;

import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;


import com.rapid.j2ee.framework.core.io.xls.config.ExcelSheetConfigure;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public class ExcelComplexReportDataWriter extends ExcelComplexWriter {

	private WritableCellFormat reportDateCellFormat;

	public ExcelComplexReportDataWriter(String file, Locale l) {
		super(file, l);
		init();
	}

	public ExcelComplexReportDataWriter(OutputStream os, Locale l) {
		super(os, l);
		init();
	}

	private void init() {
		try {

			WritableFont font = new WritableFont(WritableFont
					.createFont("微软雅黑"), 10);

			font.setColour(Colour.BLUE);

			reportDateCellFormat = new WritableCellFormat(font);
			reportDateCellFormat.setWrap(false);
			reportDateCellFormat.setAlignment(Alignment.LEFT);
			reportDateCellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void setReportDateCellFormat(WritableCellFormat reportDateCellFormat) {
		this.reportDateCellFormat = reportDateCellFormat;
	}

	protected void writeSheetAfterTitle(WritableSheet currentSheet,
			ExcelSheetConfigure currentExcelSheetConfigure,
			int sheetCurrentRowNumber) throws Throwable {

		Label reportDateLabel = new Label(0, sheetCurrentRowNumber, "制表日期："
				+ DateTimeUtils
						.getCurrentWebDate(DateTimeFormat.YYYY_MM_DD_HH_MM),
				reportDateCellFormat);

		currentSheet.mergeCells(0, sheetCurrentRowNumber,
				currentExcelSheetConfigure.getSheetCellColumns().size() - 1,
				sheetCurrentRowNumber);

		currentSheet.addCell(reportDateLabel);
		this.setCurrentRowHeight(ROW_VIEW_HEIGHT);

		this.increaseRowByOne();
	}

}
