package com.rapid.j2ee.framework.core.io.xls;

public final class ExcelComplexReportDataWriterUtils {

	private static ThreadLocal<ExcelComplexWriter> excelComplexWriter = new ThreadLocal<ExcelComplexWriter>();

	public static void prepareExcelComplexWriter(ExcelComplexWriter writer) {
		excelComplexWriter.set(writer);
	}

	public static ExcelComplexWriter getExcelComplexWriter() {

		return excelComplexWriter.get();
	}

	public static boolean isExcelComplexWriterExisted() {
		return excelComplexWriter.get() != null;
	}

	public static void release() {

		try {
			excelComplexWriter.get().close();
		} catch (Exception e) {

		}
		excelComplexWriter.remove();
	}

	public static void close(ExcelComplexWriter writer) {
		if (!isExcelComplexWriterExisted()) {
			writer.close();

		}
	}
}
