package com.rapid.j2ee.framework.core.io.xls;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;

public class ExcelWriterDemo {

	/**
	 * The workbook
	 */
	private WritableWorkbook workbook;

	private WritableSheet currentSheet;

	public ExcelWriterDemo(String file) {
		WorkbookSettings ws = new WorkbookSettings();
		ws.setLocale(Locale.CHINESE);

		try {
			workbook = Workbook.createWorkbook(new File(file), ws);
		} catch (IOException e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	public static void main(String[] args) {
		ExcelWriterDemo excel = new ExcelWriterDemo("test.xls");
		excel.write();
	}

	public void write() {
		try {
			writeLabelFormatSheet();

			writeNumberFormatSheet();

		} catch (Exception e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			close();
		}
	}

	private void close() {
		try {
			this.workbook.write();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		try {
			this.workbook.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private void writeNumberFormatSheet() throws Exception {

		currentSheet = workbook.createSheet("Number Formats", 1);

		WritableFont arial12pt = new WritableFont(WritableFont.ARIAL, 12);

		WritableCellFormat cf1 = new WritableCellFormat(arial12pt,
				NumberFormats.INTEGER);
		cf1.setAlignment(Alignment.RIGHT);

		jxl.write.Number n = new jxl.write.Number(1, 1, NumberUtils
				.parseDouble("3"), cf1);

		currentSheet.addCell(n);

	}

	private void writeLabelFormatSheet() throws Exception {

		currentSheet = workbook.createSheet("Label Formats", 0);
		currentSheet.setColumnView(0, 60);

		Label lr = new Label(0, 0, "Arial Fonts");

		currentSheet.addCell(lr);

		WritableFont arial12pt = new WritableFont(WritableFont.ARIAL, 12);

		WritableCellFormat arial12format = new WritableCellFormat(arial12pt);
		arial12format.setWrap(true);
		arial12format.setBorder(Border.ALL, BorderLineStyle.THIN);

		lr = new Label(4, 0, "Normal 12 Arial", arial12format);
		currentSheet.addCell(lr);
		lr = new Label(5, 0, "Normal 12 Arial2", arial12format);
		currentSheet.addCell(lr);

		WritableFont arial10ptBold = new WritableFont(WritableFont.ARIAL, 12,
				WritableFont.BOLD);
		WritableCellFormat arial10BoldFormat = new WritableCellFormat(
				arial10ptBold);

		arial10BoldFormat.setWrap(true);

		currentSheet.setColumnView(2, 30);

		lr = new Label(2, 2, "BOLD 12 Arial", arial10BoldFormat);
		currentSheet.addCell(lr);

		WritableFont arial10ptUnderline = new WritableFont(WritableFont.ARIAL,
				WritableFont.DEFAULT_POINT_SIZE, WritableFont.NO_BOLD, false,
				UnderlineStyle.SINGLE);

		WritableCellFormat arialUnderline = new WritableCellFormat(
				arial10ptUnderline);

		lr = new Label(6, 11, "Underline 123 我是中国人", arialUnderline);

		currentSheet.addCell(lr);

		arial12format = new WritableCellFormat(arial12pt);
		arial12format.setBorder(Border.ALL, BorderLineStyle.THIN);
		arial12format.setWrap(true);

		currentSheet.setColumnView(0, 60);

		lr = new Label(0, 24, "A very long label, more than 255 characters\012"
				+ "Rejoice O shores\012" + "Sing O bells\012"
				+ "But I with mournful tread\012"
				+ "Walk the deck my captain lies\012"
				+ "Fallen cold and dead\012"
				+ "Summer surprised, coming over the Starnbergersee\012"
				+ "With a shower of rain. We stopped in the Colonnade\012"
				+ "A very long label, more than 255 characters\012"
				+ "Rejoice O shores\012" + "Sing O bells\012"
				+ "But I with mournful tread\012"
				+ "Walk the deck my captain lies\012"
				+ "Fallen cold and dead\012"
				+ "Summer surprised, coming over the Starnbergersee\012"
				+ "With a shower of rain. We stopped in the Colonnade\012"
				+ "A very long label, more than 255 characters\012"
				+ "Rejoice O shores\012" + "Sing O bells\012"
				+ "But I with mournful tread\012"
				+ "Walk the deck my captain lies\012"
				+ "Fallen cold and dead\012"
				+ "Summer surprised, coming over the Starnbergersee\012"
				+ "With a shower of rain. We stopped in the Colonnade\012"
				+ "A very long label, more than 255 characters\012"
				+ "Rejoice O shores\012" + "Sing O bells\012"
				+ "But I with mournful tread\012"
				+ "Walk the deck my captain lies\012"
				+ "Fallen cold and dead\012"
				+ "Summer surprised, coming over the Starnbergersee\012"
				+ "With a shower of rain. We stopped in the Colonnade\012"
				+ "And sat and drank coffee an talked for an hour\012",
				arial12format);

		currentSheet.addCell(lr);
		
		
	    WritableImage wi = new WritableImage
	      (1, 3, 1, 1, new File("Gratulation.png"));
	    
	    currentSheet.setColumnView(1, 30);
	    currentSheet.setRowView(3, 2000);
	    currentSheet.addImage(wi);

	}

}
