package com.rapid.j2ee.framework.core.io.xls.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.rapid.j2ee.framework.core.collections.SortMultiHashMap;
import com.rapid.j2ee.framework.core.collections.SortMultiMap;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.DateFormat;
import jxl.write.NumberFormat;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableFont.FontName;

@SuppressWarnings("unchecked")
public abstract class AbstractExcelSheetConfigure implements
		ExcelSheetConfigure {

	private WritableCellFormat tableColumnCellFormat;

	protected Map<Integer, Map<CellType, WritableCellFormat>> tableContentCellFormatMaps = new HashMap<Integer, Map<CellType, WritableCellFormat>>();

	private SortMultiMap excelCellDecoratorMaps = new SortMultiHashMap();

	private List<SheetExcelCellColumn> cellColumns;

	public AbstractExcelSheetConfigure() {

		prepareTableColumnCellFormat();

		prepareTableContentCellFormats(getSummaryDeepMaxLevel());

	}

	protected final void addSheetExcelCellColumn(int size,
			SheetExcelCellColumn column) {

		if (TypeChecker.isNull(cellColumns)) {
			cellColumns = new ArrayList<SheetExcelCellColumn>(size);
		}

		cellColumns.add(column);

	}

	protected final void addExcelSheetCellDecorator(String cellColumn,
			ExcelSheetCellDecorator decorator) {
		excelCellDecoratorMaps.put(cellColumn.toUpperCase(), decorator);

	}

	public List<ExcelSheetCellDecorator> getExcelSheetCellDecorators(
			SheetExcelCellColumn cellColumn) {
		return excelCellDecoratorMaps.getList(cellColumn.getFieldName()
				.toUpperCase());
	}

	public final List<SheetExcelCellColumn> getSheetCellColumns() {

		return cellColumns;
	}

	protected abstract boolean hasSummaryOperation();

	protected void prepareTableColumnCellFormat() {

		try {

			WritableFont font = new WritableFont(getSheetWritableFont(), 10,
					WritableFont.BOLD);
			font.setColour(Colour.WHITE);

			tableColumnCellFormat = new WritableCellFormat(font);
			tableColumnCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableColumnCellFormat.setBackground(Colour.GRAY_50);
			tableColumnCellFormat.setAlignment(Alignment.CENTRE);
			tableColumnCellFormat.setWrap(true);
			tableColumnCellFormat
					.setVerticalAlignment(VerticalAlignment.CENTRE);

			reviseTableColumnCellFormat(tableColumnCellFormat);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	private Map<CellType, WritableCellFormat> getTableContentCellFormats(
			int summaryLevel) {

		Map<CellType, WritableCellFormat> cellFormats = new HashMap<CellType, WritableCellFormat>();

		tableContentCellFormatMaps.put(summaryLevel, cellFormats);

		return cellFormats;

	}

	protected abstract int getSummaryDeepMaxLevel();

	protected Colour getTableContentBackgroudColor(int summaryLevel) {

		if (summaryLevel == 0) {
			return Colour.WHITE;
		}

		if (summaryLevel == 1) {
			return Colour.DARK_YELLOW;
		}

		return Colour.BLUE_GREY;
	}

	private void prepareTableContentCellFormats(int summaryLevel) {

		for (int i = 0; i < summaryLevel; i++) {
			prepareTableContentCellFormats(i, getTableContentBackgroudColor(i));
		}
	}

	private void prepareTableContentCellFormats(int summaryLevel,
			Colour bgColour) {
		try {

			Map<CellType, WritableCellFormat> cellFormats = getTableContentCellFormats(summaryLevel);

			WritableFont font = new WritableFont(getSheetWritableFont(), 10);

			reviseTableContentFontByAuto(summaryLevel, font);

			WritableCellFormat tableContentCellFormat = new WritableCellFormat(
					font);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.RIGHT);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.INTEGER,
					tableContentCellFormat);

			cellFormats.put(CellType.INTEGER, tableContentCellFormat);

			NumberFormat numberFormat = new NumberFormat("#,###.00");

			tableContentCellFormat = new WritableCellFormat(font, numberFormat);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.RIGHT);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.CURRENCY,
					tableContentCellFormat);

			cellFormats.put(CellType.CURRENCY, tableContentCellFormat);

			numberFormat = new NumberFormat("#,###.00");

			tableContentCellFormat = new WritableCellFormat(font, numberFormat);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.RIGHT);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.NUMBER,
					tableContentCellFormat);

			cellFormats.put(CellType.NUMBER, tableContentCellFormat);

			numberFormat = new NumberFormat("0.00%");

			tableContentCellFormat = new WritableCellFormat(font, numberFormat);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.RIGHT);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.PERCENT,
					tableContentCellFormat);

			cellFormats.put(CellType.PERCENT, tableContentCellFormat);

			DateFormat df = new DateFormat("yyyy-MM-dd");

			tableContentCellFormat = new WritableCellFormat(font, df);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.CENTRE);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);
			reviseTableContentCellFormat(CellType.DATE, tableContentCellFormat);

			cellFormats.put(CellType.DATE, tableContentCellFormat);

			df = new DateFormat("yyyy-MM-dd hh:mm:ss");

			tableContentCellFormat = new WritableCellFormat(font, df);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.CENTRE);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.DATETIME_YYYYMMDDHHMMSS,
					tableContentCellFormat);

			cellFormats.put(CellType.DATETIME_YYYYMMDDHHMMSS,
					tableContentCellFormat);

			df = new DateFormat("yyyy-MM-dd hh:mm:ss");

			tableContentCellFormat = new WritableCellFormat(font, df);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.CENTRE);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);
			reviseTableContentCellFormat(CellType.DATETIME_YYYYMMDDHHMMSS,
					tableContentCellFormat);

			cellFormats.put(CellType.DATETIME_YYYYMMDDHHMMSS,
					tableContentCellFormat);

			tableContentCellFormat = new WritableCellFormat(font);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.STRING,
					tableContentCellFormat);

			cellFormats.put(CellType.STRING, tableContentCellFormat);
			
			cellFormats.put(CellType.IMAGE, tableContentCellFormat);

			tableContentCellFormat = new WritableCellFormat(font);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.CENTRE);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);
			reviseTableContentCellFormat(CellType.STRING_CENTER,
					tableContentCellFormat);

			cellFormats.put(CellType.STRING_CENTER, tableContentCellFormat);

			tableContentCellFormat = new WritableCellFormat(font);
			tableContentCellFormat.setBackground(bgColour);
			tableContentCellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
			tableContentCellFormat.setWrap(true);
			tableContentCellFormat.setAlignment(Alignment.RIGHT);
			tableContentCellFormat.setVerticalAlignment(VerticalAlignment.TOP);

			reviseTableContentCellFormat(CellType.STRING_RIGHT,
					tableContentCellFormat);

			cellFormats.put(CellType.STRING_RIGHT, tableContentCellFormat);

		} catch (Exception e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	protected void reviseTableContentFontByAuto(int summaryLevel,
			WritableFont font) throws Exception {

		if (summaryLevel != 0) {
			font.setBoldStyle(WritableFont.BOLD);
			font.setColour(Colour.WHITE);
		}

		reviseTableContentFont(summaryLevel, font);
	}

	protected abstract void reviseTableContentCellFormat(CellType cellType,
			WritableCellFormat cellFormat);

	protected abstract void reviseTableContentFont(int summaryLevel,
			WritableFont font);

	public CellFormat getTableColumnCellFormat(int column,
			SheetExcelCellColumn cellColumn) {
		return tableColumnCellFormat;
	}

	protected abstract void reviseTableColumnCellFormat(
			WritableCellFormat cellFormat);

	protected abstract FontName getSheetWritableFont();

	public CellFormat findCellFormatAtTableContent(int column,
			SheetExcelCellColumn cellColumn, Object record) {

		if (record instanceof ExcelSheetCellTotalRecordIndicator
				&& ((ExcelSheetCellTotalRecordIndicator) record)
						.isTotalRecord()) {

			ExcelSheetCellTotalRecordIndicator indicator = (ExcelSheetCellTotalRecordIndicator) record;

			Map<CellType, WritableCellFormat> cellFormats = tableContentCellFormatMaps
					.get(indicator.getTotalLevel());

			if (column == 0) {
				return cellFormats.get(CellType.STRING_RIGHT);
			}

			return cellFormats.get(cellColumn.getCellType());

		}

		return tableContentCellFormatMaps.get(0).get(cellColumn.getCellType());
	}

	public Object getCellValue(int column, Object record,
			SheetExcelCellColumn cellColumn, Object parentValue) {

		if (TypeChecker.isNull(record)) {
			return record;
		}

		if (record instanceof ExcelSheetCellTotalRecordIndicator) {

			ExcelSheetCellTotalRecordIndicator totalCellData = (ExcelSheetCellTotalRecordIndicator) record;

			if (totalCellData.isTotalRecord()) {
				if (column == 0) {
					return getTotalLabel(totalCellData.getTotalLevel());
				}
			}
		}

		try {

			if (cellColumn.isVirtual()) {
				return decorateCellValue(column, cellColumn, record, null,
						parentValue);
			}

			return decorateCellValue(column, cellColumn, record, BeanUtils
					.getPropertyObject(record, cellColumn.getFieldName()),
					parentValue);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	private Object decorateCellValue(int column,
			SheetExcelCellColumn cellColumn, Object record, Object value,
			Object parentValue) {

		List<ExcelSheetCellDecorator> decorators = getExcelSheetCellDecorators(cellColumn);

		if (TypeChecker.isEmpty(decorators)) {
			return value;
		}

		for (ExcelSheetCellDecorator dec : decorators) {
			value = dec.convert(column, cellColumn, record, value, parentValue);
		}

		return value;

	}

	public String getTotalLabel(int totalLevel) {
		throw new UnsupportedOperationException(
				"The method String getTotalLabel(int totalLevel) must be implemented when it implements ExcelSheetSummaryCellConfigure interface.");
	}

	public void prepare() {

	}

}
