package com.rapid.j2ee.framework.core.io.xls.config;

import java.util.HashMap;
import java.util.Map;

import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;

public abstract class AbstractExcelSheetSwitchColourRowConfigure extends
		AbstractExcelSheetConfigure implements ExcelSheetRowConfigure {

	private Map<WritableCellFormat, CellFormat> evenRowCellFormatMaps = new HashMap<WritableCellFormat, CellFormat>();

	/*
	 * 用于实现奇偶变色
	 * 
	 * @see com.anbang.galaxy.core.utils.io.xls.config.ExcelSheetRowConfigure#
	 *      findCellFormatAtTableContent(int, int,
	 *      com.anbang.galaxy.core.utils.io.xls.config.SheetExcelCellColumn,
	 *      java.lang.Object)
	 */
	public CellFormat findCellFormatAtTableContent(int row, int column,
			SheetExcelCellColumn cellColumn, Object record) {

		WritableCellFormat cellFormat = (WritableCellFormat) this
				.findCellFormatAtTableContent(column, cellColumn, record);
		
		if(cellFormat == null){
			return null;
		}

		if (record instanceof ExcelSheetCellTotalRecordIndicator
				&& ((ExcelSheetCellTotalRecordIndicator) record)
						.isTotalRecord()) {

			return cellFormat;
		}

		if (row % 2 == 0) {

			if (!evenRowCellFormatMaps.containsKey(cellFormat)) {

				try {
					WritableCellFormat evenCellFormat = new WritableCellFormat(
							cellFormat);

					evenCellFormat.setBackground(getAnotherRowColour());
					
					evenRowCellFormatMaps.put(cellFormat, evenCellFormat);

				} catch (Throwable e) {

				}

				
			}

			return evenRowCellFormatMaps.get(cellFormat);

		}

		return cellFormat;
	}

	protected  Colour getAnotherRowColour(){
		return Colour.YELLOW;
	}

}
