package com.rapid.j2ee.framework.core.io.xls.config;

import com.rapid.j2ee.framework.core.utils.StringUtils;

public class SheetExcelCellColumn implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String columnName;

	private String fieldName;

	private int columnWidth;

	private CellType cellType;

	private boolean childColumnField;

	private boolean virtual = false;

	public boolean isChildColumnField() {
		return childColumnField;
	}

	public boolean equals(Object o) {

		SheetExcelCellColumn column = (SheetExcelCellColumn) o;

		if (column == this) {
			return true;
		}

		return StringUtils.equalsIgnoreCase(column.fieldName, this.fieldName);
	}

	public int hashCode() {
		return 13 + this.fieldName.hashCode() * 7;
	}

	public SheetExcelCellColumn(String columnName, String fieldName,
			CellType cellType, boolean childColumnField, int columnWidth) {

		this.columnName = columnName;
		this.fieldName = fieldName;
		this.columnWidth = columnWidth;
		this.cellType = cellType;
		this.childColumnField = childColumnField;

	}

	public SheetExcelCellColumn(String columnName, String fieldName,
			CellType cellType, int columnWidth) {
		this(columnName, fieldName, cellType, false, columnWidth);

	}

	public int getColumnWidth() {
		return columnWidth;
	}

	public SheetExcelCellColumn setColumnWidth(int columnWidth) {
		this.columnWidth = columnWidth;
		return this;
	}

	public String getColumnName() {
		return columnName;
	}

	public String getFieldName() {
		return fieldName;
	}

	public CellType getCellType() {
		return cellType;
	}

	public boolean isVirtual() {
		return virtual;
	}

	public SheetExcelCellColumn setVirtual(boolean virtual) {

		this.virtual = virtual;

		return this;
	}

}
