package com.rapid.j2ee.framework.core.io.xls.demo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.rapid.j2ee.framework.core.io.xls.config.ExcelSheetCellTotalRecordIndicator;
import com.rapid.j2ee.framework.core.io.xls.config.SheetCellChildRecords;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;

public class DemoData implements ExcelSheetCellTotalRecordIndicator,
		SheetCellChildRecords {

	private String name;

	private String sex;

	private Integer age;

	private Double amount;

	private String remark;

	private Date dob;

	private int level;

	private boolean totalRecord;

	public DemoData(boolean totalRecord) {
		this.totalRecord = totalRecord;
		dob = DateTimeUtils.getCurrentYMDDate();
	}

	public DemoData() {
		this(false);
	}

	public Integer getAge() {
		return age;
	}

	public void setAge(Integer age) {
		this.age = age;
	}

	public Double getAmount() {
		return amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public boolean isTotalRecord() {

		return totalRecord;
	}

	public int getTotalLevel() {

		return level;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public List getChildRecords() {

		if (totalRecord) {
			return null;
		}

		List rs = new ArrayList();

		ChildDemo demo = new ChildDemo("Child 1");
		rs.add(demo);

		demo = new ChildDemo("Child 2");
		rs.add(demo);

		return rs;
	}

	public Date getDob() {
		return dob;
	}

	public void setDob(Date dob) {
		this.dob = dob;
	}

}
