package com.rapid.j2ee.framework.core.io.xls.demo;

import com.rapid.j2ee.framework.core.io.xls.config.*;

import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableFont.FontName;



public class DemoExcelSheetConfigure<DemoData> extends
		AbstractExcelSheetConfigure implements ExcelSheetSummaryCellConfigure {

	public DemoExcelSheetConfigure() {
		super();

		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("姓名", "name",
				CellType.STRING, 20));

		
		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("生日", "dob",
				CellType.DATE, 5));
		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("性别", "sex",
				CellType.STRING, 5));

		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("年龄", "age",
				CellType.INTEGER, 5));

		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("开销(元)",
				"amount", CellType.CURRENCY, 15));

		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("备注",
				"childName", CellType.STRING, true, 50));

		this.addSheetExcelCellColumn(10, new SheetExcelCellColumn("级别",
				"level", CellType.INTEGER, 5));

	}

	@Override
	protected FontName getSheetWritableFont() {

		return WritableFont.createFont("微软雅黑");
	}

	@Override
	protected int getSummaryDeepMaxLevel() {

		return 3;
	}

	@Override
	protected boolean hasSummaryOperation() {

		return false;
	}

	public int getLabelMergeCellSize(int totalLevel) {

		return 3;
	}

	public String getTotalLabel(int totalLevel) {
		if (totalLevel == 1) {
			return "小计";
		}

		if (totalLevel == 2) {
			return "总计";
		}

		return "";
	}

	@Override
	protected void reviseTableColumnCellFormat(WritableCellFormat cellFormat) {

	}

	@Override
	protected void reviseTableContentCellFormat(CellType cellType,
			WritableCellFormat cellFormat) {

	}

	@Override
	protected void reviseTableContentFont(int summaryLevel, WritableFont font) {

	}

	public int getCellContentHeight(Object record) {
		// TODO Auto-generated method stub
		return 50;
	}
}
