package com.rapid.j2ee.framework.core.io.xls.demo;

import com.rapid.j2ee.framework.core.io.xls.config.ExcelSheetTitleConfigure;

import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;



public class DemoExcelSheetTitleConfigure implements ExcelSheetTitleConfigure {

	private WritableCellFormat titleCellFormat;

	private String sheetName;

	private String titleName;

	public DemoExcelSheetTitleConfigure(String sheetName, String titleName) {

		try {
			this.sheetName = sheetName;
			this.titleName = titleName;

			WritableFont arial14pt = new WritableFont(WritableFont.ARIAL, 14);
			titleCellFormat = new WritableCellFormat(arial14pt);
			titleCellFormat.setWrap(false);
			titleCellFormat.setAlignment(Alignment.CENTRE);
			titleCellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
		} catch (Exception e) {

		}
	}

	public String getTitleName() {

		return titleName;
	}

	public String getSheetName() {

		return sheetName;
	}

	public CellFormat getTitleCellFormat() {

		return titleCellFormat;
	}

	public int getTitleCellHeight() {

		return 500;
	}

	public int getTitleStartRowNumber() {

		return 0;
	}

}
