package com.rapid.j2ee.framework.core.io.xls.demo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

import com.rapid.j2ee.framework.core.io.barcode.ImageQRCodeUtil;
import com.rapid.j2ee.framework.core.io.xls.config.CellImage;

public class DemoImage {

	private String cardId;

	public String getCardId() {
		return cardId;
	}

	public void setCardId(String cardId) {
		this.cardId = cardId;
	}

	public CellImage getCardCodeImage() {
		return new CellImage() {

			public int getWidth() {

				return 1;
			}

			public int getHeight() {

				return 1;
			}

			public byte[] getImages() {

				ByteArrayOutputStream os = new ByteArrayOutputStream();

				ImageQRCodeUtil.encode(cardId, 120, 120, os);

				return os.toByteArray();
			}

			public int getColumnWidth() {

				return 15;
			}

			public int getRowHeight() {

				return 1500;
			}

		};
	}
}
