package com.rapid.j2ee.framework.core.io.xls.demo;

import com.rapid.j2ee.framework.core.io.xls.config.*;

import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableFont.FontName;

public class DemoImageSheetConfigure extends AbstractExcelSheetSwitchColourRowConfigure {

	public DemoImageSheetConfigure() {

		super();

		this.addSheetExcelCellColumn(2, new SheetExcelCellColumn("卡号",
				"cardId", CellType.STRING, 20));

		this.addSheetExcelCellColumn(2, new SheetExcelCellColumn("卡二维码",
				"cardCodeImage", CellType.IMAGE, 5));

	}

	@Override
	protected FontName getSheetWritableFont() {

		return WritableFont.createFont("微软雅黑");
	}

	@Override
	protected void reviseTableColumnCellFormat(WritableCellFormat cellFormat) {

	}

	@Override
	protected void reviseTableContentCellFormat(CellType cellType,
			WritableCellFormat cellFormat) {

	}

	@Override
	protected void reviseTableContentFont(int summaryLevel, WritableFont font) {

	}

	@Override
	protected int getSummaryDeepMaxLevel() {

		return 1;
	}

	@Override
	protected boolean hasSummaryOperation() {

		return false;
	}


}
