package com.rapid.j2ee.framework.core.io.xls.demo;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import jxl.write.WritableImage;

import com.rapid.j2ee.framework.core.io.xls.ExcelComplexReportDataWriter;
import com.rapid.j2ee.framework.core.io.xls.ExcelComplexWriter;
import com.rapid.j2ee.framework.core.utils.RandomUtils;

public class DemoTester {

	public static void writeImageExel() {

		List<DemoImage> demoData = new ArrayList<DemoImage>(5);

		DemoImage demo = new DemoImage();
		demo.setCardId(RandomUtils.nextRandomNumber(8) + "");
		demoData.add(demo);

		demo = new DemoImage();
		demo.setCardId(RandomUtils.nextRandomNumber(8) + "");
		demoData.add(demo);

		demo = new DemoImage();
		demo.setCardId(RandomUtils.nextRandomNumber(8) + "");
		demoData.add(demo);

		DemoImageSheetConfigure config = new DemoImageSheetConfigure();

		ExcelComplexReportDataWriter excel = new ExcelComplexReportDataWriter(
				"testImage.xls", Locale.CHINESE);

		excel.writeSheetData(new DemoExcelSheetTitleConfigure("Demo Image",
				"This is a Image report made by John Hao "), config, demoData);

		excel.close();

	}

	public static void writeComplexExel() {
		try {

			DemoExcelSheetConfigure config = new DemoExcelSheetConfigure();

			List<DemoData> demoData = new ArrayList<DemoData>(5);
			DemoData demo = new DemoData();
			demo.setName("John Hao");
			demo.setAge(32);
			demo.setSex("男");
			demo.setRemark("Good");
			demo.setLevel(0);
			demo.setAmount(1000.132d);
			demoData.add(demo);
			demo = new DemoData();
			demo.setName("Tomcat");
			demo.setAge(19);
			demo.setSex("男");
			demo.setRemark("Normal");
			demo.setLevel(0);
			demo.setAmount(1500.152d);
			demoData.add(demo);
			demo = new DemoData(true);
			demo.setLevel(1);
			demo.setAmount(2500.284d);
			demoData.add(demo);
			demo = new DemoData();
			demo.setName("John Hao2");
			demo.setAge(32);
			demo.setSex("001");
			demo
					.setRemark("A very long label, more than 255 characters\012A very long label, more than 255 characters\012A very long label, more than 255 characters\012A very long label, more than 255 characters\012A very long label, more than 255 characters\012");
			demo.setLevel(0);
			demo.setAmount(1000.132d);
			demoData.add(demo);
			demo = new DemoData();
			demo.setName("Tomcat2");
			demo.setAge(19);
			demo.setSex("男");
			demo.setRemark("Normal");
			demo.setLevel(0);
			demo.setAmount(1500.152d);
			demoData.add(demo);
			demo = new DemoData(true);
			demo.setLevel(1);
			demo.setAmount(2500.284d);
			demoData.add(demo);
			demo = new DemoData(true);
			demo.setLevel(2);
			demo.setAmount(2500.284 * 2d);
			demoData.add(demo);

			ExcelComplexWriter excel = new ExcelComplexWriter("test.xls",
					Locale.getDefault());
			excel.writeSheetData(new DemoExcelSheetTitleConfigure("Demo 1",
					"This is a demo1 report made by John Hao "), config,
					demoData);

			excel.close();

			config = new DemoExcelSheetConfigure();

			excel = new ExcelComplexReportDataWriter("test.xls", Locale
					.getDefault());
			excel.writeSheetData(new DemoExcelSheetTitleConfigure("Demo 1",
					"This is a demo1 report made by John Hao "), config,
					demoData);
			excel.appendWorksheetTableContents(demoData);
			excel.writeSheetData(new DemoExcelSheetTitleConfigure("Demo 2",
					"This is a demo2 report made by John Hao "), config,
					demoData);
			excel.writeSheetData(new DemoExcelSheetTitleConfigure("Demo 3",
					"This is a demo2 report made by John Hao "), config,
					demoData);
			excel.close();

		} catch (Exception e) {
			// TODO: handle exception
		}
	}

	public static void main(String[] args) {
		writeImageExel();

		writeComplexExel();
	}

}
