package com.rapid.j2ee.framework.core.io.xml;

import java.lang.reflect.Field;
import java.util.Date;

import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;

public final class BeanXmlUtils {

	private BeanXmlUtils() {

	}

	public static <T> T bean(Class<T> beanClz, XNode node) {
		return (T) bean(ConstructorUtils.newInstance(beanClz), node);
	}

	public static Object bean(String beanClz, XNode node) {
		return bean(ConstructorUtils.newInstance(beanClz), node);
	}

	public static <T> T beanBody(Class<T> beanClz, XNode node) {
		return (T) beanBody(ConstructorUtils.newInstance(beanClz), node);
	}

	public static Object beanBody(Object bean, XNode node) {

		if (TypeChecker.isNull(node) || TypeChecker.isNull(bean)) {
			return bean;
		}

		Class beanClz = bean.getClass();

		for (XNode childNode : node.getChildren()) {

			try {

				Field field = ClassUtils.getFieldByIngoreCaseFieldName(beanClz,
						childNode.getNode().getNodeName());

				if (TypeChecker.isNull(field)) {

					continue;
				}

				InvokeUtils.setSetterMethodOrField(bean, field, childNode
						.getStringBody(""));

			} catch (Exception e) {
				System.out.print("Warning... cannot set FieldValue "
						+ childNode.getName() + " in "
						+ bean.getClass().getName());
			}
		}

		return bean;
	}

	public static Object bean(Object bean, XNode node) {

		Assert.notNull(bean);

		Class beanClass = bean.getClass();

		for (Object attributeName : node.getAttributes().keySet()) {

			BeanXmlUtils.setFieldValueOfAttribute((String) attributeName, node,
					bean, ClassUtils.getFieldByIngoreCaseFieldName(beanClass,
							(String) attributeName));

		}

		return bean;
	}

	private static void setFieldValueOfAttribute(String attributeKey,
			XNode node, Object bean, Field field) {

		try {
			if (TypeChecker.isNull(field)) {
				return;
			}

			String nodeValue = node.getStringAttribute(attributeKey, "");

			if (field.getType() == String.class) {
				InvokeUtils.setField(bean, field, nodeValue);

				return;
			}

			if (TypeChecker.isEmpty(nodeValue)) {
				InvokeUtils.setField(bean, field, null);
				return;
			}

			if (Date.class.isAssignableFrom(field.getType())) {
				InvokeUtils.setField(bean, field, DateTimeUtils
						.convertWebToDate(nodeValue,
								DateTimeFormat.YYYY_MM_DD_HH_MM_SS));

				return;
			}

			if (Double.class == field.getType()) {
				InvokeUtils.setField(bean, field, Double.valueOf(nodeValue));
				return;
			}

			if (Float.class == field.getType()) {
				InvokeUtils.setField(bean, field, Float.valueOf(nodeValue));
				return;
			}

			if (Integer.class == field.getType()) {
				InvokeUtils.setField(bean, field, Integer.valueOf(nodeValue));
				return;
			}

			if (Long.class == field.getType()) {
				InvokeUtils.setField(bean, field, Long.valueOf(nodeValue));
				return;
			}

			InvokeUtils.setField(bean, field, DateTimeUtils.convertWebToDate(
					node.getStringAttribute(attributeKey, ""),
					DateTimeFormat.YYYY_MM_DD_HH_MM_SS));

			return;

		} catch (Exception e) {
			System.out.print("Warning... cannot set FieldValue of attribute ["
					+ attributeKey + "] under field [" + field.getName()
					+ "] in " + bean.getClass().getName());
		}
	}

}
