package com.rapid.j2ee.framework.core.io.xml;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class XNodeJavaBeanResolver {

	private static XNodeJavaBeanResolver instance = new XNodeJavaBeanResolver();

	private Map<String, Field> xmlTagFieldMapper = new HashMap<String, Field>(
			50);

	private ThreadLocal<Map<Class, Field[]>> fieldsClassThreadLocalMap = new ThreadLocal<Map<Class, Field[]>>(

	) {
		@Override
		protected Map<Class, Field[]> initialValue() {

			return new HashMap<Class, Field[]>();
		}

	};

	private ThreadLocal<Map<Class, Field[]>> fieldsClassThreadLocalXPathTagBeanMap = new ThreadLocal<Map<Class, Field[]>>(

	) {
		@Override
		protected Map<Class, Field[]> initialValue() {

			return new HashMap<Class, Field[]>();
		}

	};

	public static XNodeJavaBeanResolver getInstance() {
		return instance;
	}

	private XNodeJavaBeanResolver() {

	}

	public Field[] getAllFieldsAsClassByXPathTagBean(Class beanClz) {

		if (!fieldsClassThreadLocalXPathTagBeanMap.get().containsKey(beanClz)) {

			Field[] fields = ClassUtils.getAllFieldsAsClassByAnnotation(
					beanClz, XPathTagBean.class);

			Arrays.sort(fields, new Comparator<Field>() {

				public int compare(Field field1, Field field2) {

					return field1.getAnnotation(XPathTagBean.class).order()
							- field2.getAnnotation(XPathTagBean.class).order();
				}

			});

			fieldsClassThreadLocalXPathTagBeanMap.get().put(beanClz, fields);
		}

		return fieldsClassThreadLocalXPathTagBeanMap.get().get(beanClz);
	}

	public void populate(Properties properties, Object bean) {

		if (TypeChecker.isEmpty(properties)) {
			return;
		}

		for (Object tagAttrName : properties.keySet()) {

			Field field = getFieldByTagName((String) tagAttrName, bean
					.getClass());

			if (TypeChecker.isNull(field)) {
				continue;
			}

			if (ObjectUtils.isWidePrimitive(field.getType())
					|| ObjectUtils.isBasicPrimitiveType(field.getType())) {

				this.setFieldValue(bean, field, properties, properties
						.getProperty((String) tagAttrName));
			}

		}

	}

	public void setFieldValue(Object bean, Field field, Properties properties,
			Object value) {

		if (!field.isAccessible()) {
			field.setAccessible(true);
		}

		try {
			InvokeUtils.setField(bean, field, value);
		} catch (Exception e) {

			e.printStackTrace();
		}
	}

	public Field getFieldByTagName(String tagName, Class clz) {

		String key = clz.getName() + "." + tagName;

		if (!xmlTagFieldMapper.containsKey(key)) {
			xmlTagFieldMapper.put(key, this._getFieldByTagName(tagName, clz));
		}

		return xmlTagFieldMapper.get(key);

	}

	private Field _getFieldByTagName(String tagName, Class clz) {

		tagName = ClassUtils.getFieldNameResolved(tagName, true);

		return ClassUtils.getFieldByIngoreCaseFieldName(
				getAllFieldsByClass(clz), tagName, true);

	}

	private Field[] getAllFieldsByClass(Class clz) {

		if (!fieldsClassThreadLocalMap.get().containsKey(clz)) {
			fieldsClassThreadLocalMap.get().put(clz,
					ClassUtils.getAllFieldsAsClass(clz));
		}

		return fieldsClassThreadLocalMap.get().get(clz);
	}

	public void clear() {
		fieldsClassThreadLocalMap.remove();
		fieldsClassThreadLocalXPathTagBeanMap.remove();
	}
}
