package com.rapid.j2ee.framework.core.io.xml;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

import com.rapid.j2ee.framework.core.io.xml.test.PageoutputPapckage;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class XmlPaserJavaBean<T> {

	private XPathParser xPathParser;

	private T xmlResolveBean;

	private XmlPaserJavaBeanFilter xmlPaserJavaBeanFilter = XmlPaserJavaBeanFilter.Default;

	public XmlPaserJavaBean(XPathParser xPathParser,
			Class<? extends T> xmlResolveBeanClass) {

		xmlResolveBean = (T) ConstructorUtils.newInstance(xmlResolveBeanClass);

		this.xPathParser = xPathParser;
	}

	public void addXmlPaserJavaBeanFilter(
			XmlPaserJavaBeanFilter xmlPaserJavaBeanFilter) {

		this.xmlPaserJavaBeanFilter = xmlPaserJavaBeanFilter;
	}

	public T resolve() {

		this.resolveObject(xmlResolveBean, null);

		XNodeJavaBeanResolver.getInstance().clear();

		return xmlResolveBean;
	}

	private Object resolveObject(Object bean, XNode xNode) {

		if (!TypeChecker.isNull(xNode)) {
			XNodeJavaBeanResolver.getInstance().populate(
					getXmlNodeAttributesAndChildrenTagBodies(xNode), bean);
		}

		for (Field field : XNodeJavaBeanResolver.getInstance()
				.getAllFieldsAsClassByXPathTagBean(bean.getClass())) {

			this.resolveObjectField(field, bean, xNode);

		}

		String nodeName = "Document";

		if (!TypeChecker.isNull(xNode)) {
			nodeName = xNode.getName();
		}

		return xmlPaserJavaBeanFilter.resolve(xmlResolveBean, nodeName, bean,
				xNode, xPathParser);

	}

	private Class getTagNodeBeanClassName(Field field, XPathTagBean xmlPathClass) {

		if (xmlPathClass.beanClass() != Object.class) {
			return xmlPathClass.beanClass();
		}

		if (!TypeChecker.isNull(field.getGenericType())
				&& field.getGenericType().toString().contains("<")) {
			return ClassUtils.forName(StringUtils.splitClosure(field
					.getGenericType().toString(), "<", ">")[0]);
		}

		return field.getType();
	}

	public void resolveObjectField(Field field, Object bean, XNode xNodeParent) {

		XPathTagBean xmlPathClass = field.getAnnotation(XPathTagBean.class);

		if (Collection.class.isAssignableFrom(field.getType())) {

			List<XNode> xNodeItems = evalNodes(xNodeParent, xmlPathClass
					.value());

			List items = new ArrayList(xNodeItems.size());

			Class itemBeanClz = getTagNodeBeanClassName(field, xmlPathClass);

			for (XNode xNode : xNodeItems) {

				Object beanNode = ConstructorUtils.newInstance(itemBeanClz);

				beanNode = resolveObject(beanNode, xNode);

				items.add(beanNode);

			}

			XNodeJavaBeanResolver.getInstance().setFieldValue(bean, field,
					ObjectUtils.EMTPY_PROPERTIES, items);

			return;
		}

		XNode itemNode = evalNode(xNodeParent, xmlPathClass.value());

		if (field.getType() == String.class
				|| ObjectUtils.isBasicPrimitiveType(field.getType())
				|| ObjectUtils.isWidePrimitive(field.getType())) {

			if (TypeChecker.isNull(itemNode)) {
				return;
			}

			XNodeJavaBeanResolver.getInstance().setFieldValue(bean, field,
					ObjectUtils.EMTPY_PROPERTIES,
					itemNode.getNode().getTextContent());

			return;
		}

		Object itemBean = ConstructorUtils.newInstance(getTagNodeBeanClassName(
				field, xmlPathClass));

		if (TypeChecker.isNull(itemNode)) {
			return;
		}

		itemBean = resolveObject(itemBean, itemNode);

		XNodeJavaBeanResolver.getInstance().setFieldValue(bean, field,
				ObjectUtils.EMTPY_PROPERTIES, itemBean);

	}

	private XNode evalNode(XNode xNodeParent, String path) {

		if (!TypeChecker.isNull(xNodeParent)) {
			return xNodeParent.evalNode(path);
		}

		return this.xPathParser.evalNode(path);
	}

	private List<XNode> evalNodes(XNode xNodeParent, String path) {

		if (!TypeChecker.isNull(xNodeParent)) {
			return xNodeParent.evalNodes(path);
		}

		return this.xPathParser.evalNodes(path);
	}

	private Properties getXmlNodeAttributesAndChildrenTagBodies(XNode xNode) {

		Properties properties = xNode.getAttributes();

		for (XNode childNode : xNode.getChildren()) {

			properties.put(childNode.getNode().getNodeName(), childNode
					.getNode().getTextContent());
		}

		return properties;
	}

	public static void main(String[] args) throws UnsupportedEncodingException {

		XPathParser xPathParser = new XPathParser(XmlPaserJavaBean.class
				.getResourceAsStream("messageWebServiceAction.do.xml"), "utf-8");

		XmlPaserJavaBean xmlReaderObject = new XmlPaserJavaBean(xPathParser,
				PageoutputPapckage.class);

		PageoutputPapckage pageoutputPapckage = (PageoutputPapckage) xmlReaderObject
				.resolve();

		System.out.println(ObjectAnalyzer.toString(pageoutputPapckage
				.getOutputHeader()));

		System.out.println(ObjectAnalyzer.toString(pageoutputPapckage
				.getPageInfo()));

		System.out.println(StringUtils.printCollections(pageoutputPapckage
				.getMessages()));

		pageoutputPapckage = (PageoutputPapckage) xmlReaderObject.resolve();

		System.out.println(ObjectAnalyzer.toString(pageoutputPapckage
				.getOutputHeader()));

		System.out.println(ObjectAnalyzer.toString(pageoutputPapckage
				.getPageInfo()));

		System.out.println(StringUtils.printCollections(pageoutputPapckage
				.getMessages()));
	}

}
