package com.rapid.j2ee.framework.core.lock;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

import org.springframework.util.Assert;

@SuppressWarnings("unchecked")
public class GlobalFSFileAccessLock extends
		AbstractGlobalAccessLock<RandomAccessFile> {

	public static ThreadLocal<RandomAccessFile> randomAccessFileThreadLocal = new ThreadLocal<RandomAccessFile>();

	public GlobalFSFileAccessLock(String lockFilePath) {
		this.lockFilePath = lockFilePath;
	}

	public GlobalFSFileAccessLock() {

	}

	public RandomAccessFile getLockHandler() {

		return randomAccessFileThreadLocal.get();
	}

	public void release(RandomAccessFile randomAccessFile) {

		if (randomAccessFile == null) {
			return;
		}
		try {
			randomAccessFile.seek(0);
			randomAccessFile.writeLong(0);

			randomAccessFileThreadLocal.remove();

		} catch (Exception e) {

		} finally {

			this.close(randomAccessFile);

		}
	}

	@Override
	public boolean tryLock(Class target, String method, int autoReleaseMin) {

		Assert
				.hasLength(lockFilePath,
						"Please provide lock file path! Call setLockFilePath(path) method!");

		RandomAccessFile randomAccessFile = null;

		try {

			int autoReleaseTime = autoReleaseMin * 60 * 1000;

			File file = new File(lockFilePath, target.getSimpleName() + method
					+ Lock_File_Extension);

			file.getParentFile().mkdirs();

			randomAccessFile = new RandomAccessFile(file, "rw");

			if (!this.isLockAvailable(randomAccessFile, autoReleaseTime)) {

				this.close(randomAccessFile);

				return false;
			}

			randomAccessFile.seek(0);

			randomAccessFile.writeChars(String.valueOf(System
					.currentTimeMillis()));

			randomAccessFileThreadLocal.set(randomAccessFile);

			return true;

		} catch (Exception e) {

			this.close(randomAccessFile);

			return false;
		}

	}

	private boolean isLockAvailable(RandomAccessFile randomAccessFile,
			int autoReleaseTime) throws Exception {

		FileChannel fc = randomAccessFile.getChannel();
		FileLock fl = fc.tryLock();

		if (!fl.isValid()) {

			return false;
		}

		if (randomAccessFile.length() == 0) {
			return true;
		}

		randomAccessFile.seek(0);

		long lastExecutedTime = randomAccessFile.readLong();

		if (lastExecutedTime == 0) {
			return true;
		}

		return System.currentTimeMillis() - lastExecutedTime >= autoReleaseTime;

	}

	private void close(RandomAccessFile randomAccessFile) {
		try {
			randomAccessFile.close();
		} catch (Exception ep) {

		}
	}

	public void setLockFilePath(String lockFilePath) {
		this.lockFilePath = lockFilePath;
	}

	private String lockFilePath;

	public static final String Lock_File_Extension = ".lock";

}
