package com.rapid.j2ee.framework.core.memorycache;

import java.util.HashMap;
import java.util.Map;

import com.opensymphony.xwork2.ActionContext;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class BusinessServiceActionContextCache implements BusinessServiceCache {

	private static final ThreadLocal<Map<String, Object>> Business_Service_ThreadLocal_Cache = new ThreadLocal<Map<String, Object>>();

	public Map<String, Object> getActionContextThreadLocalCacheMap() {

		if (ActionContext.getContext() == null
				|| ActionContext.getContext().getContextMap() == null) {

			System.out
					.println("No Action Context.....................................................");

			return new HashMap<String, Object>();

		}

		Map<String, Object> cached = (Map<String, Object>) ActionContext
				.getContext().getContextMap().get(
						"BusinessServiceActionContextCache."
								+ categoryNameCahced);

		if (TypeChecker.isNull(cached)) {
			
			cached = new HashMap<String, Object>(20);

			ActionContext.getContext().getContextMap().put(
					"BusinessServiceActionContextCache." + categoryNameCahced,
					cached);
		}

		return cached;
	}

	public boolean hasCachedValue(String key) {

		return getActionContextThreadLocalCacheMap().containsKey(key);
	}

	public Object storeValue(String key, Object value) {

		getActionContextThreadLocalCacheMap().put(key, value);

		return value;

	}

	public Object getValueCached(String key) {

		return getActionContextThreadLocalCacheMap().get(key);
	}

	public void remove(String... keys) {

		for (String key : keys) {
			getActionContextThreadLocalCacheMap().remove(key);
		}

	}

	public void removeAll() {
		getActionContextThreadLocalCacheMap().clear();

	}

	public Strategy getCacheStrategy() {

		return Strategy.ActionContext;
	}

	public void setCategoryNameCahced(String categoryNameCahced) {
		this.categoryNameCahced = categoryNameCahced;
	}

	private String categoryNameCahced = "General_Category_ActionContext_Cache";

}
