package com.rapid.j2ee.framework.core.memorycache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;

public class BusinessServiceCacheSelector implements InitializingBean {

	@Autowired
	private List<BusinessServiceCache> businessServiceCaches = new ArrayList<BusinessServiceCache>();

	private Map<Strategy, BusinessServiceCache> businessServiceCachesByStrategy = new HashMap<Strategy, BusinessServiceCache>();

	public BusinessServiceCache getBusinessServiceCache(Strategy strategy) {
		Assert.isTrue(businessServiceCachesByStrategy.containsKey(strategy),
				"Please provide the business service cache by the strategy["
						+ strategy + "]");
		return businessServiceCachesByStrategy.get(strategy);
	}

	public void afterPropertiesSet() throws Exception {
		for (BusinessServiceCache businessServiceCache : businessServiceCaches) {
			businessServiceCachesByStrategy.put(businessServiceCache
					.getCacheStrategy(), businessServiceCache);
		}
	}

}
