package com.rapid.j2ee.framework.core.memorycache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.cryptology.CryptologyFactory;
import com.rapid.j2ee.framework.core.cryptology.CryptologyType;
import com.rapid.j2ee.framework.core.memorycache.resolve.DatabaseCacheObjectResolver;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public abstract class BusinessServiceDatabaseCache implements
		BusinessServiceCache, InitializingBean {

	public Strategy getCacheStrategy() {

		return Strategy.Database;
	}

	public Object getValueCached(String key) {

		return this.getDatabaseCacheObjectResolver(key).resolveAfterRetrieve(
				this.getValueCachedByDatabase(this.getService(key), this
						.getMethod(key), CryptologyFactory.getSingleCryptology(
						CryptologyType.Md5).encrypt(key)));
	}

	private DatabaseCacheObjectResolver getDatabaseCacheObjectResolver(
			String key) {

		String newKey = this.getService(key) + "." + this.getMethod(key);

		Assert.isTrue(databaseCacheObjectResolverMaps.containsKey(newKey),
				"Please setup a valid DatabaseCacheObjectResolver for key:"
						+ newKey);

		return databaseCacheObjectResolverMaps.get(newKey);
	}

	protected abstract String getValueCachedByDatabase(String action,
			String method, String keyMd5);

	private String getService(String key) {

		return StringUtils.substringBeforeLast(StringUtils.substringBeforeLast(
				StringUtils.substringBefore(key, ","), "."), ".");
	}

	public String getMethod(String key) {

		String serviceMethod = StringUtils.substringBeforeLast(StringUtils
				.substringBeforeLast(key, ","), ".");

		return StringUtils.substringAfterLast(serviceMethod, ".");
	}

	public boolean hasCachedValue(String key) {

		return this.hasCachedValue(this.getService(key), this.getMethod(key),
				CryptologyFactory.getSingleCryptology(CryptologyType.Md5)
						.encrypt(key));
	}

	protected abstract boolean hasCachedValue(String action, String method,
			String keyMd5);

	public Object storeValue(String key, Object bean) {

		storeValueToDatabase(this.getService(key), this.getMethod(key),
				CryptologyFactory.getSingleCryptology(CryptologyType.Md5)
						.encrypt(key), this.getDatabaseCacheObjectResolver(key)
						.resolveBeforePersistence(bean), this
						.getDatabaseCacheObjectResolver(key).getExpireInSec());

		return bean;
	}

	public abstract void storeValueToDatabase(String action, String method,
			String md5Key, String beanValue, int expireInSec);

	public void remove(String... key) {

	}

	public void removeAll() {

	}

	public void afterPropertiesSet() throws Exception {

		for (DatabaseCacheObjectResolver databaseCacheObjectResolver : this.databaseCacheObjectResolvers) {
			databaseCacheObjectResolverMaps.put(databaseCacheObjectResolver
					.getService().getName()
					+ "." + databaseCacheObjectResolver.getMethod(),
					databaseCacheObjectResolver);
		}
	}

	@Autowired(required = false)
	private List<DatabaseCacheObjectResolver> databaseCacheObjectResolvers = new ArrayList<DatabaseCacheObjectResolver>();

	private Map<String, DatabaseCacheObjectResolver> databaseCacheObjectResolverMaps = new HashMap<String, DatabaseCacheObjectResolver>();

	public static void main(String[] args) {
		System.out.println(StringUtils.substringBefore("abc", ","));
	}
}
