package com.rapid.j2ee.framework.core.memorycache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotification;
import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotificationAware;
import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotification.Operations;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class BusinessServiceStaticMemoryCache implements BusinessServiceCache,
		BusinessServiceCacheChangeNotificationAware {

	public synchronized Object getValueCached(String key) {

		return Static_Memory_Container.get(key);

	}

	public synchronized boolean hasCachedValue(String key) {

		return Static_Memory_Container.containsKey(key);

	}

	public void remove(String... keys) {

		synchronized (Static_Memory_Container) {

			for (String key : keys) {
				removeByKey(key);
			}

		}

		businessServiceCacheChangeNotification.notice(Operations.Remove,
				StringUtils.getStringBunch(keys, "$~$"), null);

	}

	private void removeByKey(String key) {

		System.out
				.println("BusinessServiceStaticMemoryCache Remove Cached Key:"
						+ key);
		for (String name : new HashSet<String>(Static_Memory_Container.keySet())) {
			System.out.println("Cache Real Key Name:" + name);
			if (!name.startsWith(key)) {
				continue;
			}

			Object obj = Static_Memory_Container.remove(name);

			System.out
					.println("BusinessServiceStaticMemoryCache Remove Cached Real Key:"
							+ name);

			obj = null;

		}
	}

	public Object storeValue(String key, Object value) {

		synchronized (Static_Memory_Container) {
			Static_Memory_Container.put(key, value);
		}

		businessServiceCacheChangeNotification.notice(Operations.Add, key,
				value);

		return value;
	}

	public void removeAll() {

		synchronized (Static_Memory_Container) {
			Static_Memory_Container.clear();
		}

		businessServiceCacheChangeNotification.notice(Operations.RemoveAll,
				null, null);
	}

	public void setBusinessServiceCacheChangeNotification(
			BusinessServiceCacheChangeNotification businessServiceCacheChangeNotification) {
		this.businessServiceCacheChangeNotification = businessServiceCacheChangeNotification;
	}

	public Strategy getCacheStrategy() {

		return Strategy.Static;
	}

	private static final Map<String, Object> Static_Memory_Container = new HashMap<String, Object>(
			50);

	@Autowired(required = false)
	private BusinessServiceCacheChangeNotification businessServiceCacheChangeNotification = new BusinessServiceCacheChangeNotification() {

		public void notice(Operations operation, String key, Object value) {

		}

	};
}
