package com.rapid.j2ee.framework.core.memorycache;

import java.util.HashMap;
import java.util.Map;

import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class BusinessServiceThreadLocalCache implements BusinessServiceCache {

	private static final ThreadLocal<Map<String, Object>> Business_Service_ThreadLocal_Cache = new ThreadLocal<Map<String, Object>>();

	public boolean hasCachedValue(String key) {

		return !TypeChecker.isEmpty(Business_Service_ThreadLocal_Cache.get())
				&& Business_Service_ThreadLocal_Cache.get().containsKey(key);
	}

	public Object storeValue(String key, Object value) {

		if (TypeChecker.isNull(Business_Service_ThreadLocal_Cache.get())) {
			Business_Service_ThreadLocal_Cache
					.set(new HashMap<String, Object>());
		}

		Business_Service_ThreadLocal_Cache.get().put(key, value);

		return value;

	}

	public Object getValueCached(String key) {

		return Business_Service_ThreadLocal_Cache.get().get(key);
	}

	public void remove(String... keys) {

		if (TypeChecker.isNull(Business_Service_ThreadLocal_Cache.get())) {
			return;
		}

		for (String key : keys) {
			Business_Service_ThreadLocal_Cache.get().remove(key);
		}

	}

	public void removeAll() {

		if (TypeChecker.isNull(Business_Service_ThreadLocal_Cache.get())) {
			return;
		}

		Business_Service_ThreadLocal_Cache.get().clear();
	}

	public Strategy getCacheStrategy() {

		return Strategy.ThreadLocal;
	}
}
