package com.rapid.j2ee.framework.core.memorycache.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.memorycache.BusinessServiceCache;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.ArgumentKeyStrategy;
import com.rapid.j2ee.framework.core.memorycache.strategy.CacheStrategy.Strategy;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class BusinessServiceCacheAopAroundAdivice implements InitializingBean {

	@Autowired
	private List<BusinessServiceCache> businessServiceCaches = new ArrayList<BusinessServiceCache>();

	private Map<Strategy, BusinessServiceCache> businessServiceCacheMaps;

	protected Log logger = LogFactory.getLog(this.getClass());

	public Object doCacheReturnedValue(ProceedingJoinPoint point) {

		try {
			if (TypeChecker.isEmpty(businessServiceCacheMaps)) {
				return point.proceed();
			}
			MethodSignature methodSignature = (MethodSignature) point
					.getSignature();
			logger
					.debug("Aop Cached Result Service[AutowireBusinessServiceCacheAspectJAroundAdivice.doCacheReturnedValue] in "
							+ methodSignature.getName()
							+ " in "
							+ point.getTarget().getClass().getName());

			removePossibleStaticMemory(point);

			if (!this.hasMethodReturnedCacheRequire(methodSignature)) {

				logger
						.debug("Aop Cached Result Service[AutowireBusinessServiceCacheAspectJAroundAdivice.doCacheReturnedValue] not cached.... "
								+ methodSignature.getName()
								+ " in "
								+ point.getTarget().getClass().getName());

				return point.proceed();
			}

			String cacheKey = getMethodSignatureParameterCachedKey(point
					.getTarget(), methodSignature.getMethod(), point.getArgs());

			logger
					.debug("Aop Cached Result Service[AutowireBusinessServiceCacheAspectJAroundAdivice.doCacheReturnedValue] for cached key "
							+ cacheKey
							+ " method:"
							+ methodSignature.getName()
							+ " in " + point.getTarget().getClass().getName());

			if (!this.getBusinessServiceCache(methodSignature).hasCachedValue(
					cacheKey)) {

				logger
						.debug("Aop Cached Result Service[AutowireBusinessServiceCacheAspectJAroundAdivice.doCacheReturnedValue] get will be cached value in "
								+ methodSignature.getName()
								+ " in "
								+ point.getTarget().getClass().getName());

				return this.storeValue(cacheKey, point, methodSignature);

			}

			try {

				return this.getValueCached(methodSignature, cacheKey);

			} catch (Throwable e) {
				return this.storeValue(cacheKey, point, methodSignature);
			}

		} catch (Throwable e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private Object storeValue(String cacheKey, ProceedingJoinPoint point,
			MethodSignature methodSignature) throws Throwable {
		return this.getBusinessServiceCache(methodSignature).storeValue(
				cacheKey, point.proceed());
	}

	private Object getValueCached(MethodSignature methodSignature,
			String cacheKey) {

		Object value = this.getBusinessServiceCache(methodSignature)
				.getValueCached(cacheKey);

		if (TypeChecker.isNull(value)
				|| !this.isCloneReturnValue(methodSignature)) {

			return value;
		}

		if (value instanceof Cloneable) {

			log.debug("Clone Value success!!! for cacheKey " + cacheKey
					+ " Method " + methodSignature.getMethod().getName());

			return InvokeUtils.invoke(value, "clone", null, null);
		}

		return ObjectUtils.cloneObject(value);

	}

	private void removePossibleStaticMemory(ProceedingJoinPoint point) {

		MethodSignature methodSignature = (MethodSignature) point
				.getSignature();

		if (!this.isRefreshCacheRequired(methodSignature)) {
			return;
		}

		Method[] methods = ClassUtils.getAllMethodsAsClassByAnnotation(point
				.getTarget().getClass(), CacheStrategy.class);

		if (TypeChecker.isEmpty(methods)) {
			return;
		}

		String[] keys = new String[methods.length];

		int index = 0;

		for (Method method : methods) {

			keys[index++] = point.getTarget().getClass().getName() + "."
					+ method.getName();

		}

		this.doRemoveBusinessServiceCaches(keys);

	}

	private void doRemoveBusinessServiceCaches(String[] keys) {

		if (TypeChecker.isEmpty(businessServiceCaches)) {
			return;
		}

		for (BusinessServiceCache businessServiceCache : businessServiceCaches) {
			businessServiceCache.remove(keys);
		}

	}

	private String getMethodSignatureParameterCachedKey(Object target,
			Method method, Object[] arguments) {

		StringBuffer key = new StringBuffer(500);

		key.append(target.getClass().getName());
		key.append(".");
		key.append(method.getName());
		key.append(".");

		if (TypeChecker.isEmpty(arguments)) {

			return key.toString();
		}

		boolean staticCacheArgumentKeyStrategy = ArgumentKeyStrategy.Static == method
				.getAnnotation(CacheStrategy.class).argumentKeyStrategy();

		for (Object arg : arguments) {

			key.append(",");

			if (TypeChecker.isNull(arg)) {
				key.append("NULL");
				continue;
			}

			if (staticCacheArgumentKeyStrategy) {
				key.append(arg.getClass());
			} else {
				key.append(ObjectAnalyzer.toString(arg));
			}

		}

		return key.toString();

	}

	private boolean hasMethodReturnedCacheRequire(
			MethodSignature methodSignature) {

		return ClassUtils.hasAnnotationAtMethod(methodSignature.getMethod(),
				CacheStrategy.class);
	}

	private BusinessServiceCache getBusinessServiceCache(
			MethodSignature methodSignature) {

		return businessServiceCacheMaps.get(((CacheStrategy) methodSignature
				.getMethod().getAnnotation(CacheStrategy.class)).strategy());
	}

	private boolean isCloneReturnValue(MethodSignature methodSignature) {
		return ((CacheStrategy) methodSignature.getMethod().getAnnotation(
				CacheStrategy.class)).cloneable();
	}

	private boolean isRefreshCacheRequired(MethodSignature methodSignature) {

		return ClassUtils.hasAnnotationAtMethod(methodSignature.getMethod(),
				RefreshCache.class);
	}

	public void afterPropertiesSet() throws Exception {

		businessServiceCacheMaps = new HashMap<Strategy, BusinessServiceCache>();

		if (TypeChecker.isEmpty(businessServiceCaches)) {
			return;
		}

		for (BusinessServiceCache businessServiceCache : this.businessServiceCaches) {

			businessServiceCacheMaps.put(businessServiceCache
					.getCacheStrategy(), businessServiceCache);

			log.info("BusinessServiceCache : "
					+ businessServiceCache.getCacheStrategy() + " for "
					+ businessServiceCache.getClass());
		}

	}

	private Log log = LogFactory
			.getLog(BusinessServiceCacheAopAroundAdivice.class);

}
