package com.rapid.j2ee.framework.core.memorycache.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;
import org.aspectj.runtime.internal.AroundClosure;

import com.rapid.j2ee.framework.core.reflect.InvokeUtils;

public class MethodProceedingJoinPoint implements ProceedingJoinPoint {

	private Object target;

	private Object[] arguments;

	private MethodSignature methodSignature = null;

	public MethodProceedingJoinPoint(Object target, String methodName,
			Object[] arguments) {

		this.target = target;

		this.arguments = arguments;

		methodSignature = new MethodSignatureImpl(InvokeUtils.findMethod(target
				.getClass(), methodName));

	}

	public MethodProceedingJoinPoint(Object target, String methodName,
			Class[] argumentClazz, Object[] arguments) {

		this.target = target;

		this.arguments = arguments;

		methodSignature = new MethodSignatureImpl(InvokeUtils.findMethod(target
				.getClass(), methodName, argumentClazz, false));
	}

	public Object proceed() throws Throwable {

		return methodSignature.getMethod().invoke(target, arguments);
	}

	public Object proceed(Object[] arg) throws Throwable {

		return proceed();
	}

	public void set$AroundClosure(AroundClosure arg0) {
		throw new UnsupportedOperationException("set$AroundClosure()");
	}

	public Object[] getArgs() {

		return arguments;
	}

	public String getKind() {

		throw new UnsupportedOperationException("getKind()");
	}

	public Signature getSignature() {

		return methodSignature;
	}

	public SourceLocation getSourceLocation() {

		throw new UnsupportedOperationException("getSourceLocation()");
	}

	public StaticPart getStaticPart() {

		throw new UnsupportedOperationException("StaticPart()");
	}

	public Object getTarget() {

		return this.target;
	}

	public Object getThis() {

		throw new UnsupportedOperationException("getThis()");
	}

	public String toLongString() {

		return methodSignature.toLongString();
	}

	public String toShortString() {

		return methodSignature.toShortString();
	}

}
