package com.rapid.j2ee.framework.core.memorycache.aop;

import java.lang.reflect.Method;

import org.aspectj.lang.reflect.MethodSignature;

public class MethodSignatureImpl implements MethodSignature {

	private Method method;

	public MethodSignatureImpl(Method method) {
		
		this.method = method;
	}

	public Method getMethod() {

		return method;
	}

	public Class getReturnType() {

		return method.getReturnType();
	}

	public Class[] getExceptionTypes() {

		return method.getExceptionTypes();
	}

	public String[] getParameterNames() {

		throw new UnsupportedOperationException("getParameterNames");
	}

	public Class[] getParameterTypes() {

		return method.getParameterTypes();
	}

	public Class getDeclaringType() {

		return method.getDeclaringClass();
	}

	public String getDeclaringTypeName() {

		return method.getDeclaringClass().getName();
	}

	public int getModifiers() {

		return method.getModifiers();
	}

	public String getName() {

		return method.getName();
	}

	public String toLongString() {

		return method.toGenericString();
	}

	public String toShortString() {

		return method.toGenericString();
	}

}
