package com.rapid.j2ee.framework.core.memorycache.notification;

import java.nio.charset.Charset;
import java.util.List;

import org.apache.http.util.EntityUtils;

import com.rapid.j2ee.framework.core.io.http.HttpPostClient;
import com.rapid.j2ee.framework.core.io.http.HttpResponseEntity;
import com.rapid.j2ee.framework.core.utils.FileUtils;

public abstract class AbstractBusinessServiceCacheChangeHttpNotification extends
		AbstractBusinessServiceCacheChangeNotification {

	@Override
	protected void doSendNotification(Operations operation, String key,
			Object value) {

		for (String url : getWebSitesNotificated()) {
			doSendNotification(url, operation, key, value);
		}
	}

	protected void doSendNotification(final String url,
			final Operations operation, final String key, final Object value) {

		try {
			System.out.println("doSendNotification() Called. URL =="
					+ FileUtils.getFullFilePathName(url,
							this.notificationReceiverPage) + " Operation="
					+ operation + " Key=" + key);

			new Thread() {
				public void run() {
					HttpPostClient toolkit = new HttpPostClient(FileUtils
							.getFullFilePathName(url, notificationReceiverPage));
					toolkit
							.addParameter("operation", String
									.valueOf(operation));
					toolkit.addParameter("key", key);
					toolkit.setConnectionTimeout(1000 * 10);
					toolkit.setHttpMethodTimeout(1000 * 10);

					HttpResponseEntity entity = toolkit.execute();

					try {
						System.out
								.println("doSendNotification Status Code ======= "
										+ entity.getStatusCode()
										+ " Result"
										+ EntityUtils.toString(entity, Charset
												.forName("utf-8")));
					} catch (Exception e) {

					}

				}
			}.start();

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	protected abstract List<String> getWebSitesNotificated();

	public void setNotificationReceiverPage(String notificationReceiverPage) {
		this.notificationReceiverPage = notificationReceiverPage;
	}

	private String notificationReceiverPage = Notification_Receiver_Page;

}
