package com.rapid.j2ee.framework.core.memorycache.notification;

public abstract class AbstractBusinessServiceCacheChangeNotification implements
		BusinessServiceCacheChangeNotification {

	public void notice(Operations operation, String key, Object value) {

		if (!BusinessServiceCacheChangeNotificationSwitch.isOpened()) {
			return;
		}

		if (!this.isSendNotificationAvailable(operation, key, value)) {
			return;
		}

		this.doSendNotification(operation, key, value);
	}

	protected abstract void doSendNotification(Operations operation,
			String key, Object value);

	protected boolean isSendNotificationAvailable(Operations operation,
			String key, Object value) {

		if (operation == Operations.Add) {
			return false;
		}

		return true;
	}

}
