package com.rapid.j2ee.framework.core.memorycache.receiver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotification;
import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotificationSwitch;
import com.rapid.j2ee.framework.core.memorycache.notification.BusinessServiceCacheChangeNotification.Operations;
import com.rapid.j2ee.framework.core.utils.Constants;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class BusinessServiceCacheMemoryChangeHandlerFilter implements Filter {

	private FilterConfig filterConfig;

	private List<BusinessServiceCacheMemoryChangeReceiver> businessServiceCacheMemoryChangeReceivers = ObjectUtils.EMPTY_LIST;

	private ApplicationContext applicationContext;

	private Constants operationsContants = new Constants(Operations.class);

	private BusinessServiceCacheMemoryChangeReceiver defaultBusinessServiceCacheMemoryChangeReceiver = new BusinessServiceCacheMemoryChangeReceiver() {

		public String getCacheKey() {

			return "DEFAULT";
		}

		public void process(Operations operation, String key,
				HttpServletRequest request) {

		}

	};

	public void init(FilterConfig filterConfig) throws ServletException {

		this.filterConfig = filterConfig;

		this.applicationContext = WebApplicationContextUtils
				.getWebApplicationContext(filterConfig.getServletContext());

		this.initBusinessServiceCacheMemoryChangeReceivers();

	}

	public void doFilter(ServletRequest servletRequest,
			ServletResponse servletResponse, FilterChain filterChain)
			throws IOException, ServletException {

		HttpServletRequest request = (HttpServletRequest) servletRequest;

		if (!StringUtils
				.trimToEmpty(request.getRequestURI())
				.endsWith(
						StringUtils
								.trimToEmpty(
										filterConfig
												.getInitParameter("notification_receiver_page"),
										BusinessServiceCacheChangeNotification.Notification_Receiver_Page))) {
			filterChain.doFilter(servletRequest, servletResponse);

			return;
		}

		this.doBusinessServiceCacheMemoryChangeProcess(request);

		filterChain.doFilter(servletRequest, servletResponse);

	}

	private void doBusinessServiceCacheMemoryChangeProcess(
			HttpServletRequest request) {

		if (!this.isRequestParametersLegal(request)) {
			return;
		}

		try {

			BusinessServiceCacheChangeNotificationSwitch.close();

			for (String key : StringUtils.splitBySeparator(request
					.getParameter("key"), "$~$")) {
				findBusinessServiceCacheMemoryChangeReceiver(key).process(
						(Operations) operationsContants.asObject(request
								.getParameter("operation")), key, request);
			}

		} catch (Exception e) {

		} finally {
			BusinessServiceCacheChangeNotificationSwitch.remove();
		}
		System.out.println("Filter Completed！！！！");
	}

	private boolean isRequestParametersLegal(HttpServletRequest request) {
		return !TypeChecker.isEmpty(request.getParameter("key"))
				&& !TypeChecker.isEmpty(request.getParameter("operation"));
	}

	private BusinessServiceCacheMemoryChangeReceiver findBusinessServiceCacheMemoryChangeReceiver(
			String key) {

		key = StringUtils.trimToEmpty(key);

		for (BusinessServiceCacheMemoryChangeReceiver businessServiceCacheMemoryChangeReceiver : businessServiceCacheMemoryChangeReceivers) {
			if (key.startsWith(businessServiceCacheMemoryChangeReceiver
					.getCacheKey())) {
				return businessServiceCacheMemoryChangeReceiver;
			}
		}

		for (BusinessServiceCacheMemoryChangeReceiver businessServiceCacheMemoryChangeReceiver : businessServiceCacheMemoryChangeReceivers) {
			if ("For-ALL".equalsIgnoreCase(key)) {
				return businessServiceCacheMemoryChangeReceiver;
			}
		}

		return defaultBusinessServiceCacheMemoryChangeReceiver;
	}

	public void destroy() {

	}

	private void initBusinessServiceCacheMemoryChangeReceivers() {

		String[] beanNames = applicationContext
				.getBeanNamesForType(BusinessServiceCacheMemoryChangeReceiver.class);

		if (TypeChecker.isEmpty(beanNames)) {
			return;
		}

		businessServiceCacheMemoryChangeReceivers = new ArrayList<BusinessServiceCacheMemoryChangeReceiver>(
				beanNames.length);

		for (String beanName : beanNames) {
			businessServiceCacheMemoryChangeReceivers
					.add((BusinessServiceCacheMemoryChangeReceiver) applicationContext
							.getBean(beanName));
		}

	}

}
