package com.rapid.j2ee.framework.core.memorycache.resolve;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.core.memorycache.resolve.DatabaseCacheObjectResolver;

public abstract class DatabaseCacheObjectJsonResolver implements
		DatabaseCacheObjectResolver {

	protected abstract Class<?> getJsonObjectClass();

	public Object resolveAfterRetrieve(String dbValue) {

		return JsonUtils.jsonToBean(getJsonObjectClass(), dbValue);
	}

	public String resolveBeforePersistence(Object bean) {

		return JsonUtils.formatJsonText(bean);
	}

}
