package com.rapid.j2ee.framework.core.memorycache.strategy;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface CacheStrategy {

	
	public Strategy strategy() default Strategy.Static;

	public ArgumentKeyStrategy argumentKeyStrategy() default ArgumentKeyStrategy.Dynamic;

	public boolean cloneable() default false;

	public enum Strategy {
		Static, ActionContext, ThreadLocal, NoCache, Database
	};

	public enum ArgumentKeyStrategy {
		Static, Dynamic
	};
}
