package com.rapid.j2ee.framework.core.reflect;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;



public class BeanMergePropertyNullVoidAcceptor implements
		BeanMergePropertyAcceptor {

	public boolean accept(String fieldName, Object fromValue) {

		if (TypeChecker.isNull(fromValue)) {
			return false;
		}

		if (fromValue == ObjectUtils.EMPTY_CLASS_ARRAYS
				|| fromValue == ObjectUtils.EMPTY_LIST
				|| fromValue == ObjectUtils.EMPTY_MAP
				|| fromValue == ObjectUtils.EMPTY_MULTIHASHMAP
				|| fromValue == ObjectUtils.EMPTY_OBJECT_ARRAYS
				|| fromValue == ObjectUtils.EMPTY_STRING_ARRAYS
				|| fromValue == ObjectUtils.EMPTY_SORTHASHMAP) {
			return false;
		}

		return true;
	}

	public Object getValue(Object fromValue) {

		return fromValue;
	}

}
