package com.rapid.j2ee.framework.core.reflect;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.collections.SynchronizedHashMap;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;

public class ConstructorUtils {

	private static Map<Class, Object> CONTAINERS = new SynchronizedHashMap<Class, Object>();

	public static void clear() {
		CONTAINERS.clear();
		CONTAINERS = null;
	}

	public static Object newCacheInstance(Class clz, Class[] paramType,
			Object[] paramValue) {

		if (!CONTAINERS.containsKey(clz)) {
			CONTAINERS.put(clz, newInstance(clz, paramType, paramValue));
		}
		return CONTAINERS.get(clz);

	}

	public static Object newCacheInstance(String clz, Class[] paramType,
			Object[] paramValue) {
		try {
			return newCacheInstance(ClassUtils.forName(clz), paramType,
					paramValue);
		} catch (Exception ex) {

			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static Object newInstance(String clz, Class[] paramType,
			Object[] paramValue) {
		try {

			return newInstance(ClassUtils.forName(clz), paramType, paramValue);
		} catch (Exception ex) {

			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static Object newInstance(Class clz, Class[] paramType,
			Object[] paramValue) {
		try {
			return clz.getConstructor(paramType).newInstance(paramValue);
		} catch (Exception ex) {
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static Object newInstance(String clz) {
		try {
			return newInstance(ClassUtils.forName(clz));
		} catch (Exception ex) {

			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static Object newCacheInstance(String clz) {
		try {

			return newCacheInstance(ClassUtils.forName(clz));
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static <T> T newInstance(Class<T> clz) {
		try {

			return (T) clz.newInstance();

		} catch (Exception ex) {

			logger.error("newInstance error ! Class Type:"
					+ ClassUtils.getClassModifierName(clz) + " Class:" + clz);

			throw ExceptionUtils.convertThrowableToBaseException(ex);
		}

	}

	public static synchronized <T> T newCacheInstance(Class<T> clz) {
		if (!CONTAINERS.containsKey(clz)) {
			CONTAINERS.put(clz, newInstance(clz));
		}
		return (T) CONTAINERS.get(clz);

	}

	public static boolean isConstructorAvailable(Class clz, Class[] paramType) {
		try {
			clz.getConstructor(paramType);
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	private static Log logger = LogFactory.getLog(ConstructorUtils.class);

}
