package com.rapid.j2ee.framework.core.reflect.invoker;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class GetFieldInvoker implements FieldInvoker {
	private Field field;

	public GetFieldInvoker(Field field) {
		this.field = field;
	}

	public Object invoke(Object target, Object[] args)
			throws IllegalAccessException, InvocationTargetException {
		return field.get(target);
	}

	public Class<?> getType() {
		return field.getType();
	}

	public Field getField() {

		return field;
	}
	
	
	public String toString(){
		return this.getClass().getName() +"." + this.field.getName();
	}

	public String invokerName() {
		return field.getName();
	}
}
